/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import org.drools.lang.dsl.DSLMappingEntry;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MappingEditor
extends TitleAreaDialog {
    private static final int SCOPE_KEYWORD = 0;
    private static final int SCOPE_WHEN = 1;
    private static final int SCOPE_THEN = 2;
    private static final int SCOPE_ALL = 3;
    private static final String SCOPE_STR_KEYWORD = "keyword";
    private static final String SCOPE_STR_WHEN = "condition";
    private static final String SCOPE_STR_THEN = "consequence";
    private static final String SCOPE_STR_ALL = "*";
    private Text exprText;
    private Text mappingText;
    private Text objText;
    private Combo scopeCombo;
    private boolean cancelled;
    private DSLMappingEntry model;

    protected MappingEditor(Shell shell) {
        super(shell);
    }

    public void setNLMappingItem(DSLMappingEntry dSLMappingEntry) {
        this.model = dSLMappingEntry;
        this.setSection(this.model.getSection());
        this.exprText.setText(this.model.getMappingKey() == null ? "" : this.model.getMappingKey());
        this.mappingText.setText(this.model.getMappingValue() == null ? "" : this.model.getMappingValue());
        this.objText.setText(this.model.getMetaData().getMetaData() == null ? "" : this.model.getMetaData().getMetaData());
    }

    private void setSection(DSLMappingEntry.Section section) {
        if (section == DSLMappingEntry.CONDITION) {
            this.scopeCombo.select(1);
        } else if (section == DSLMappingEntry.CONSEQUENCE) {
            this.scopeCombo.select(2);
        } else if (section == DSLMappingEntry.ANY) {
            this.scopeCombo.select(3);
        } else if (section == DSLMappingEntry.KEYWORD) {
            this.scopeCombo.select(0);
        } else {
            throw new IllegalArgumentException("Unknown scope type: " + section);
        }
    }

    private DSLMappingEntry.Section getSection(String string) {
        DSLMappingEntry.Section section = DSLMappingEntry.ANY;
        if (SCOPE_STR_KEYWORD.equals(string)) {
            section = DSLMappingEntry.KEYWORD;
        } else if (SCOPE_STR_WHEN.equals(string)) {
            section = DSLMappingEntry.CONDITION;
        } else if (SCOPE_STR_THEN.equals(string)) {
            section = DSLMappingEntry.CONSEQUENCE;
        }
        return section;
    }

    protected void cancelPressed() {
        this.cancelled = true;
        super.cancelPressed();
    }

    protected void okPressed() {
        this.cancelled = false;
        this.model.setMappingKey(this.exprText.getText());
        this.model.setMappingValue(this.mappingText.getText());
        this.model.setSection(this.getSection(this.scopeCombo.getText()));
        this.model.setMetaData((DSLMappingEntry.MetaData)new DSLMappingEntry.DefaultDSLEntryMetaData(this.objText.getText()));
        super.okPressed();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 10;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.createExpressionField(composite);
        this.createMappingField(composite);
        this.createObjectField(composite);
        this.createScopeField(composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 10;
        gridLayout2.marginWidth = 10;
        gridLayout2.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout2);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        return composite2;
    }

    private void createMappingField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Rule mapping:");
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(128));
        this.mappingText = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 450;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mappingText.setLayoutData((Object)gridData);
        this.mappingText.setToolTipText("Enter the rule language mapping that the \nlanguage item will be translated to. Use the named variables (holes) \nthat you specify in the language expression above.");
    }

    private void createExpressionField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Language expression:");
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(128));
        this.exprText = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 450;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.exprText.setLayoutData((Object)gridData);
        this.exprText.setToolTipText("Enter the language expression that you want to use in a rule.\nUse curly brackets to mark 'holes' where the values will be extracted\nfrom in the rule source. Such as: Person has a name of {name} \nThis will then parse the rule source to extract the data out of \nthe place where {name} would appear.");
    }

    private void createObjectField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Object:");
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(128));
        this.objText = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 450;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.objText.setLayoutData((Object)gridData);
        this.objText.setToolTipText("Enter the name of the object.");
    }

    private void createScopeField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Scope:");
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(128));
        this.scopeCombo = new Combo(composite, 8);
        this.scopeCombo.add(SCOPE_STR_KEYWORD, 0);
        this.scopeCombo.add(SCOPE_STR_WHEN, 1);
        this.scopeCombo.add(SCOPE_STR_THEN, 2);
        this.scopeCombo.add(SCOPE_STR_ALL, 3);
        this.scopeCombo.select(3);
        this.scopeCombo.setLayoutData((Object)new GridData(32));
        this.scopeCombo.setFont(composite.getFont());
        this.scopeCombo.setToolTipText("This specifies what part of the rule the expression applies. Indicating '*' means global.");
    }
}

