/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.HashMap;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.editors.DRLDocumentProvider;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.DroolsPairMatcher;
import org.drools.eclipse.editors.outline.RuleContentOutlinePage;
import org.drools.eclipse.editors.scanners.RuleEditorMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.actions.ToggleBreakpointAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AbstractRuleEditor
extends TextEditor {
    protected RuleContentOutlinePage ruleContentOutline = null;
    protected Annotation[] oldAnnotations;
    protected ProjectionAnnotationModel annotationModel;
    protected DroolsPairMatcher bracketMatcher = new DroolsPairMatcher();

    public AbstractRuleEditor() {
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setDocumentProvider(this.createDocumentProvider());
        this.getPreferenceStore().setDefault("Drools.DRLMatchingBrackets", true);
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"Drools.DRLMatchingBracketsColor", (RGB)new RGB(192, 192, 192));
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return new DRLSourceViewerConfig(this);
    }

    protected IDocumentProvider createDocumentProvider() {
        return new DRLDocumentProvider();
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.install();
        projectionViewer.doOperation(19);
        this.annotationModel = projectionViewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        ProjectionViewer projectionViewer = new ProjectionViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
        this.getSourceViewerDecorationSupport((ISourceViewer)projectionViewer);
        return projectionViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        sourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        sourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("Drools.DRLMatchingBrackets", "Drools.DRLMatchingBracketsColor");
        super.configureSourceViewerDecorationSupport(sourceViewerDecorationSupport);
    }

    public void updateFoldingStructure(List list) {
        if (this.annotationModel != null) {
            Annotation[] annotationArray = new Annotation[list.size()];
            HashMap hashMap = new HashMap();
            int n = 0;
            while (n < list.size()) {
                ProjectionAnnotation projectionAnnotation = new ProjectionAnnotation();
                hashMap.put(projectionAnnotation, list.get(n));
                annotationArray[n] = projectionAnnotation;
                ++n;
            }
            this.annotationModel.modifyAnnotations(this.oldAnnotations, hashMap, null);
            this.oldAnnotations = annotationArray;
        }
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction textOperationAction = new TextOperationAction(RuleEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)textOperationAction);
        textOperationAction = new TextOperationAction(RuleEditorMessages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)textOperationAction);
        textOperationAction = new ToggleBreakpointAction(this.getSite().getPart(), null, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerDoubleClick", (IAction)textOperationAction);
    }

    protected ContentOutlinePage getContentOutline() {
        if (this.ruleContentOutline == null) {
            this.ruleContentOutline = new RuleContentOutlinePage(this);
            this.ruleContentOutline.update();
        }
        return this.ruleContentOutline;
    }

    public String getContent() {
        return this.getSourceViewer().getDocument().get();
    }

    public IResource getResource() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return null;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IContentOutlinePage.class)) {
            return this.getContentOutline();
        }
        return super.getAdapter(clazz);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        DroolsEclipsePlugin.getDefault().invalidateResource(this.getResource());
        super.doSave(iProgressMonitor);
        if (this.ruleContentOutline != null) {
            this.ruleContentOutline.update();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.bracketMatcher != null) {
            this.bracketMatcher.dispose();
            this.bracketMatcher = null;
        }
    }
}

