/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLProblemAnnotation;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class DRLReconcilingStrategy
implements IReconcilingStrategy {
    private static final Pattern RULE_PATTERN = Pattern.compile("\\n\\s*(rule\\s+.*?\\n\\s*end)", 32);
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\n\\s*(template\\s+.*?\\n\\s*end)", 32);
    private static final Pattern QUERY_PATTERN = Pattern.compile("\\n\\s*(query\\s+.*?\\n\\s*end)", 32);
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\n\\s*(function\\s+[^\\{]*\\{)", 32);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("\\n\\s*((\\s*import\\s+[^\\s;]+;?[\\t\\x0B\\f\\r]*\\n)+)", 32);
    private ISourceViewer sourceViewer;
    private AbstractRuleEditor editor;
    private IDocument document;
    private boolean folding;

    public DRLReconcilingStrategy(ISourceViewer iSourceViewer, final AbstractRuleEditor abstractRuleEditor) {
        this.sourceViewer = iSourceViewer;
        this.editor = abstractRuleEditor;
        IPreferenceStore iPreferenceStore = DroolsEclipsePlugin.getDefault().getPreferenceStore();
        this.folding = iPreferenceStore.getBoolean("Drools.EditorFolding");
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("Drools.EditorFolding".equals(propertyChangeEvent.getProperty())) {
                    DRLReconcilingStrategy.this.folding = (Boolean)propertyChangeEvent.getNewValue();
                    if (DRLReconcilingStrategy.this.folding) {
                        DRLReconcilingStrategy.this.reconcile();
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                abstractRuleEditor.updateFoldingStructure(new ArrayList());
                            }
                        });
                    }
                }
            }
        });
    }

    public void setDocument(IDocument iDocument) {
        this.document = iDocument;
        this.reconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion iRegion) {
        this.reconcile();
    }

    public void reconcile(IRegion iRegion) {
        this.reconcile();
    }

    private void reconcile() {
        if (this.document != null) {
            String string = this.document.get();
            if (this.folding) {
                this.calculateFolding(string);
            }
        }
    }

    private static void createAnnotation(IFile iFile, IAnnotationModel iAnnotationModel, String string, int n, int n2) {
        DRLProblemAnnotation dRLProblemAnnotation = new DRLProblemAnnotation(string);
        Position position = new Position(0, 1);
        iAnnotationModel.addAnnotation((Annotation)dRLProblemAnnotation, position);
    }

    public static void removeAnnotationsFor(IAnnotationModel iAnnotationModel) {
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof DRLProblemAnnotation)) continue;
            iAnnotationModel.removeAnnotation(annotation);
        }
    }

    protected void calculateFolding(String string) {
        final ArrayList<Position> arrayList = new ArrayList<Position>();
        Matcher matcher = RULE_PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = QUERY_PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = TEMPLATE_PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = IMPORT_PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(new Position(matcher.start(1), matcher.end(1) - matcher.start(1)));
        }
        matcher = FUNCTION_PATTERN.matcher(string);
        block4: while (matcher.find()) {
            int n = matcher.start(1);
            int n2 = 1;
            int n3 = matcher.end();
            while (n3 < string.length()) {
                if (string.charAt(n3) == '{') {
                    ++n2;
                } else if (string.charAt(n3) == '}' && --n2 == 0) {
                    arrayList.add(new Position(n, n3 - n + 1));
                    continue block4;
                }
                ++n3;
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                DRLReconcilingStrategy.this.editor.updateFoldingStructure(arrayList);
            }
        });
    }
}

