/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.DroolsParserException;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DescrUtil;
import org.drools.eclipse.editors.DroolsLineBreakpointAdapter;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRLRuleEditor
extends AbstractRuleEditor {
    protected List<String> imports;
    protected List<String> functions;
    protected Map<String, FactTemplateDescr> templates;
    protected List<GlobalDescr> globals;
    protected String packageName;
    protected List<String> classesInPackage;
    protected Map<String, String> attributes;

    public List<String> getImports() {
        if (this.imports == null || this.isDirty()) {
            this.loadImportsAndFunctions();
        }
        return this.imports;
    }

    public List<String> getFunctions() {
        if (this.functions == null) {
            this.loadImportsAndFunctions();
        }
        return this.functions;
    }

    public Set<String> getTemplates() {
        if (this.templates == null) {
            this.loadImportsAndFunctions();
        }
        return this.templates.keySet();
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.loadImportsAndFunctions();
        }
        return this.attributes;
    }

    public FactTemplateDescr getTemplate(String string) {
        if (this.templates == null) {
            this.loadImportsAndFunctions();
        }
        return this.templates.get(string);
    }

    public List<GlobalDescr> getGlobals() {
        if (this.globals == null) {
            this.loadImportsAndFunctions();
        }
        return this.globals;
    }

    public String getPackage() {
        if (this.packageName == null) {
            this.loadImportsAndFunctions();
        }
        return this.packageName;
    }

    public List<String> getClassesInPackage() {
        if (this.classesInPackage == null) {
            this.classesInPackage = this.getAllClassesInPackage(this.getPackage());
        }
        return this.classesInPackage;
    }

    protected List<String> getAllClassesInPackage(String string) {
        IEditorInput iEditorInput;
        List<String> list = new ArrayList<String>();
        if (string != null && (iEditorInput = this.getEditorInput()) instanceof IFileEditorInput) {
            IProject iProject = ((IFileEditorInput)iEditorInput).getFile().getProject();
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            list = DRLRuleEditor.getAllClassesInPackage(string, iJavaProject);
        }
        return list;
    }

    public static List<String> getAllClassesInPackage(String string, IJavaProject iJavaProject) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        CompletionRequestor completionRequestor = new CompletionRequestor(){

            public void accept(CompletionProposal completionProposal) {
                String string = new String(completionProposal.getCompletion());
                if (completionProposal.getKind() == 9) {
                    arrayList.add(string);
                }
            }
        };
        try {
            iJavaProject.newEvaluationContext().codeComplete(String.valueOf(string) + ".", string.length() + 1, completionRequestor);
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
        return arrayList;
    }

    protected List<String> getAllStaticMethodsInClass(String string) {
        IEditorInput iEditorInput;
        final ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && (iEditorInput = this.getEditorInput()) instanceof IFileEditorInput) {
            IProject iProject = ((IFileEditorInput)iEditorInput).getFile().getProject();
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            CompletionRequestor completionRequestor = new CompletionRequestor(){

                public void accept(CompletionProposal completionProposal) {
                    String string = new String(completionProposal.getCompletion());
                    if (completionProposal.getKind() == 6) {
                        arrayList.add(string.substring(0, string.length() - 2));
                    }
                }
            };
            try {
                iJavaProject.newEvaluationContext().codeComplete(String.valueOf(string) + ".", string.length() + 1, completionRequestor);
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        }
        return arrayList;
    }

    protected void loadImportsAndFunctions() {
        try {
            List list;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseResource(this, true, false);
            PackageDescr packageDescr = dRLInfo.getPackageDescr();
            this.packageName = dRLInfo.getPackageName();
            List list2 = packageDescr.getImports();
            this.imports = new ArrayList<String>();
            if (this.packageName != null) {
                this.imports.addAll(this.getAllClassesInPackage(this.packageName));
            }
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object4 = ((ImportDescr)iterator.next()).getTarget();
                if (((String)object4).endsWith(".*")) {
                    object3 = ((String)object4).substring(0, ((String)object4).length() - 2);
                    this.imports.addAll(this.getAllClassesInPackage((String)object3));
                    continue;
                }
                this.imports.add((String)object4);
            }
            object4 = packageDescr.getFunctions();
            object3 = packageDescr.getFunctionImports();
            this.functions = new ArrayList<String>(object4.size());
            Iterator iterator2 = object4.iterator();
            while (iterator2.hasNext()) {
                this.functions.add(((FunctionDescr)iterator2.next()).getName());
            }
            Iterator iterator3 = object3.iterator();
            while (iterator3.hasNext()) {
                object2 = ((FunctionImportDescr)iterator3.next()).getTarget();
                if (((String)object2).endsWith(".*")) {
                    object = ((String)object2).substring(0, ((String)object2).length() - 2);
                    this.functions.addAll(this.getAllStaticMethodsInClass((String)object));
                    continue;
                }
                int n = ((String)object2).lastIndexOf(46);
                if (n == -1) continue;
                this.functions.add(((String)object2).substring(n + 1));
            }
            object2 = packageDescr.getFactTemplates();
            this.templates = new HashMap<String, FactTemplateDescr>(object2.size());
            object = object2.iterator();
            while (object.hasNext()) {
                list = (FactTemplateDescr)object.next();
                this.templates.put(list.getName(), (FactTemplateDescr)list);
            }
            list = packageDescr.getGlobals();
            this.globals = new ArrayList<GlobalDescr>();
            Iterator iterator4 = list.iterator();
            while (iterator4.hasNext()) {
                this.globals.add((GlobalDescr)iterator4.next());
            }
            this.attributes = new HashMap<String, String>();
            for (AttributeDescr attributeDescr : packageDescr.getAttributes()) {
                if (attributeDescr == null || attributeDescr.getName() == null) continue;
                this.attributes.put(attributeDescr.getName(), attributeDescr.getValue());
            }
        }
        catch (DroolsParserException droolsParserException) {
            DroolsEclipsePlugin.log(droolsParserException);
        }
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz.equals(IToggleBreakpointsTarget.class)) {
            return this.getBreakpointAdapter();
        }
        return super.getAdapter(clazz);
    }

    private Object getBreakpointAdapter() {
        return new DroolsLineBreakpointAdapter();
    }

    @Override
    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        this.imports = null;
        this.functions = null;
        this.templates = null;
        this.globals = null;
        this.packageName = null;
        this.classesInPackage = null;
    }

    public void gotoMarker(IMarker iMarker) {
        try {
            if (iMarker.getType().equals("org.drools.eclipse.droolsBreakpointMarker")) {
                int n = iMarker.getAttribute("Drools_DRL_LineNumber", -1);
                if (n > -1) {
                    --n;
                }
                try {
                    IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                    this.selectAndReveal(iDocument.getLineOffset(n), iDocument.getLineLength(n));
                }
                catch (BadLocationException badLocationException) {
                    DroolsEclipsePlugin.log(badLocationException);
                }
            } else {
                super.gotoMarker(iMarker);
            }
        }
        catch (CoreException coreException) {
            DroolsEclipsePlugin.log(coreException);
        }
    }

    public BaseDescr getDescr(int n) {
        try {
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseResource(this, true, false);
            return DescrUtil.getDescr((BaseDescr)dRLInfo.getPackageDescr(), n);
        }
        catch (DroolsParserException droolsParserException) {
            return null;
        }
    }
}

