/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.lang.reflect.InvocationTargetException;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.ZoomInAction2;
import org.drools.eclipse.editors.ZoomOutAction2;
import org.drools.eclipse.editors.rete.ReteViewer;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

public class DRLRuleEditor2
extends FormEditor {
    private DRLRuleEditor textEditor;
    private ReteViewer reteViewer;
    private ZoomComboContributionItem zitem;
    private ZoomInAction2 zoomIn;
    private ZoomOutAction2 zoomOut;
    protected ReteGraph graph;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    protected void addPages() {
        try {
            this.textEditor = new DRLRuleEditor(){

                public void close(boolean bl) {
                    super.close(bl);
                    DRLRuleEditor2.this.close(bl);
                }

                protected void setPartName(String string) {
                    super.setPartName(string);
                    DRLRuleEditor2.this.setPartName(string);
                }
            };
            this.reteViewer = new ReteViewer(this.textEditor);
            int n = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            int n2 = this.addPage((IEditorPart)this.reteViewer, this.getEditorInput());
            this.setPageText(n, "\u30c6\u30ad\u30b9\u30c8\u30a8\u30c7\u30a3\u30bf");
            this.setPageText(n2, "Rete\u30c4\u30ea\u30fc");
            this.textEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).addDocumentListener(new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                }

                public void documentChanged(DocumentEvent documentEvent) {
                    DRLRuleEditor2.this.reteViewer.fireDocumentChanged();
                }
            });
        }
        catch (PartInitException partInitException) {
            DroolsEclipsePlugin.log(partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.textEditor.doSave(iProgressMonitor);
        this.setInput(this.getEditorInput());
    }

    public void doSaveAs() {
        this.textEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.textEditor.isSaveAsAllowed();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == ZoomManager.class) {
            if (this.getActiveEditor() instanceof ReteViewer) {
                return this.reteViewer.getAdapter(clazz);
            }
            if (this.getActiveEditor() instanceof DRLRuleEditor) {
                return null;
            }
        } else {
            if (clazz == ZoomInAction2.class) {
                return this.zoomIn;
            }
            if (clazz == ZoomOutAction2.class) {
                return this.zoomOut;
            }
            if (clazz == ZoomComboContributionItem.class) {
                return this.zitem;
            }
        }
        return this.textEditor.getAdapter(clazz);
    }

    private void updateZoomItems() {
        this.updateZoomIn();
        this.updateZoomOut();
        this.updateZoomCombo();
    }

    private void updateZoomCombo() {
        if (this.zitem != null) {
            this.zitem.setZoomManager(this.getZoomManager());
        }
    }

    private void updateZoomIn() {
        boolean bl;
        boolean bl2 = bl = this.getZoomManager() != null;
        if (this.zoomIn != null) {
            this.zoomIn.setZoomManager(this.getZoomManager());
            this.zoomIn.setEnabled(bl);
        }
    }

    private void updateZoomOut() {
        boolean bl;
        boolean bl2 = bl = this.getZoomManager() != null;
        if (this.zoomOut != null) {
            this.zoomOut.setZoomManager(this.getZoomManager());
            this.zoomOut.setEnabled(bl);
        }
    }

    public void setZoomComboContributionItem(ZoomComboContributionItem zoomComboContributionItem) {
        this.zitem = zoomComboContributionItem;
        this.updateZoomCombo();
    }

    private ZoomManager getZoomManager() {
        return (ZoomManager)this.getAdapter(ZoomManager.class);
    }

    public void setZoomOutAction(ZoomOutAction2 zoomOutAction2) {
        this.zoomOut = zoomOutAction2;
        this.updateZoomOut();
    }

    public void setZoomInAction(ZoomInAction2 zoomInAction2) {
        this.zoomIn = zoomInAction2;
        this.updateZoomIn();
    }

    public void setFocus() {
        if (this.getActivePage() == 1) {
            boolean bl = false;
            this.graph = null;
            try {
                final String string = this.textEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
                IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        try {
                            DRLRuleEditor2.this.graph = DRLRuleEditor2.this.reteViewer.loadReteModel(iProgressMonitor, string);
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof InvocationTargetException) {
                                throw (InvocationTargetException)throwable;
                            }
                            if (throwable instanceof InterruptedException) {
                                throw (InterruptedException)throwable;
                            }
                            throw new InvocationTargetException(throwable);
                        }
                    }
                };
                this.getEditorSite().getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(iRunnableWithProgress);
                this.reteViewer.drawGraph(this.graph);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println(invocationTargetException.getTargetException().getMessage());
                if (invocationTargetException.getTargetException() != null && "\u30eb\u30fc\u30eb\u3092\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002RETE\u30d3\u30e5\u30fc\u3092\u8868\u793a\u3067\u304d\u307e\u305b\u3093\u3002".equals(invocationTargetException.getTargetException().getMessage())) {
                    Status status = new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), -1, "Unable to show Rete Tree when rules cannot be parsed correctly.", null);
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Rete Tree Build Error", (String)"Unable to parse rules, please correct rules first.", (IStatus)status);
                } else {
                    this.handleError(invocationTargetException);
                }
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Rete Tree Error!", (String)"Rete Tree Calculation Cancelled!");
                bl = true;
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
                bl = true;
            }
            if (bl) {
                this.setActivePage(0);
            }
        }
        super.setFocus();
        this.updateZoomItems();
    }

    private void handleError(Throwable throwable) {
        String string;
        DroolsEclipsePlugin.log(throwable);
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            throwable2 = throwable;
        }
        if ((string = String.valueOf(throwable2.getClass().getName()) + ": " + throwable2.getMessage()) == null || string.length() == 0) {
            string = "Uncategorized Error!";
        }
        Status status = new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), -1, string, null);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Rete Tree Build Error!", (String)"Rete Tree Build Error!", (IStatus)status);
    }

    public void setActivePage(int n) {
        super.setActivePage(n);
    }
}

