/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.ColorManager;
import org.drools.eclipse.editors.DRLReconcilingStrategy;
import org.drools.eclipse.editors.completion.DefaultCompletionProcessor;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.editors.scanners.DRLScanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class DRLSourceViewerConfig
extends SourceViewerConfiguration {
    private DRLScanner scanner;
    private AbstractRuleEditor editor;

    public DRLSourceViewerConfig(AbstractRuleEditor abstractRuleEditor) {
        this.editor = abstractRuleEditor;
    }

    protected AbstractRuleEditor getEditor() {
        return this.editor;
    }

    protected DRLScanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new DRLScanner();
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__partition_rule_content");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__partition_rule_content");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(ColorManager.getInstance().getColor(ColorManager.SINGLE_LINE_COMMENT))));
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__partition_multiline_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__partition_multiline_comment");
        return presentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new DefaultCompletionProcessor(this.editor), "__dftl_partition_content_type");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new RuleCompletionProcessor(this.editor), "__partition_rule_content");
        contentAssistant.setProposalPopupOrientation(10);
        return contentAssistant;
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return DRLPartionScanner.LEGAL_CONTENT_TYPES;
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        MonoReconciler monoReconciler = null;
        if (iSourceViewer != null) {
            monoReconciler = new MonoReconciler((IReconcilingStrategy)new DRLReconcilingStrategy(iSourceViewer, this.editor), false);
            monoReconciler.setDelay(500);
            monoReconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        }
        return monoReconciler;
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer iSourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new DefaultAnnotationHover();
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute textAttribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)textAttribute));
        }
    }
}

