/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.Stack;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public final class DroolsPairMatcher
implements ICharacterPairMatcher {
    private int anchor;
    private static final char[] leftChars = new char[]{'(', '{', '['};
    private static final char[] rightChars = new char[]{')', '}', ']'};

    public IRegion match(IDocument iDocument, int n) {
        if (n <= 0) {
            return null;
        }
        try {
            char c = iDocument.getChar(n - 1);
            int n2 = 0;
            while (n2 < rightChars.length) {
                if (c == rightChars[n2]) {
                    return this.searchLeft(iDocument, n, rightChars[n2], leftChars[n2]);
                }
                if (c == leftChars[n2]) {
                    return this.searchRight(iDocument, n, rightChars[n2], leftChars[n2]);
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {
            DroolsEclipsePlugin.log(badLocationException);
        }
        return null;
    }

    private IRegion searchRight(IDocument iDocument, int n, char c, char c2) throws BadLocationException {
        Stack<Character> stack = new Stack<Character>();
        this.anchor = 1;
        char[] cArray = iDocument.get(n, iDocument.getLength() - n).toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == c2) {
                stack.push(new Character(cArray[n2]));
            } else if (cArray[n2] == c) {
                if (stack.isEmpty()) {
                    return new Region(n - 1, n2 + 2);
                }
                stack.pop();
            }
            ++n2;
        }
        return null;
    }

    private IRegion searchLeft(IDocument iDocument, int n, char c, char c2) throws BadLocationException {
        Stack<Character> stack = new Stack<Character>();
        this.anchor = 0;
        char[] cArray = iDocument.get(0, n - 1).toCharArray();
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            if (cArray[n2] == c) {
                stack.push(new Character(cArray[n2]));
            } else if (cArray[n2] == c2) {
                if (stack.isEmpty()) {
                    return new Region(n2, n - n2);
                }
                stack.pop();
            }
            --n2;
        }
        return null;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void dispose() {
    }

    public void clear() {
    }
}

