/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractCompletionProcessor
implements IContentAssistProcessor {
    private IEditorPart editor;

    public AbstractCompletionProcessor(IEditorPart iEditorPart) {
        this.editor = iEditorPart;
    }

    protected IEditorPart getEditor() {
        return this.editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        List list = this.getCompletionProposals(iTextViewer, n);
        if (list == null) {
            return new ICompletionProposal[0];
        }
        Collections.sort(list, new RuleCompletionProposal.RuleCompletionProposalComparator());
        return list.toArray(new ICompletionProposal[list.size()]);
    }

    protected abstract List getCompletionProposals(ITextViewer var1, int var2);

    protected static void filterProposalsOnPrefix(String string, List list) {
        if (string != null && string.trim().length() > 0) {
            Iterator iterator = list.iterator();
            String string2 = string.toLowerCase();
            while (iterator.hasNext()) {
                ICompletionProposal iCompletionProposal = (ICompletionProposal)iterator.next();
                String string3 = iCompletionProposal.getDisplayString().toLowerCase();
                if (string3.toLowerCase().startsWith(string2)) continue;
                iterator.remove();
            }
        }
    }

    protected String readBackwards(int n, IDocument iDocument) throws BadLocationException {
        int n2 = iDocument.getPartition(n).getOffset();
        String string = iDocument.get(n2, n - n2);
        return string;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

