/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.DroolsEditorType;
import org.drools.lang.DroolsSentence;
import org.drools.lang.DroolsToken;
import org.drools.lang.DroolsTreeAdaptor;
import org.drools.lang.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionContext {
    static final Pattern MVEL_DIALECT_PATTERN = Pattern.compile(".*dialect\\s+\"mvel\".*", 32);
    static final Pattern JAVA_DIALECT_PATTERN = Pattern.compile(".*dialect\\s+\"java\".*", 32);
    static final String MVEL_DIALECT = "mvel";
    static final String JAVA_DIALECT = "java";
    private LinkedList<Object> parserList;
    private int location;
    private int locationIndex;
    private String dialect;

    public CompletionContext(String string) {
        DRLParser dRLParser = this.getParser(string);
        try {
            dRLParser.compilation_unit();
        }
        catch (Exception exception) {}
        this.parserList = ((DroolsSentence)dRLParser.getEditorInterface().get(0)).getContent();
        this.deriveLocation();
        this.determineDialect(string);
    }

    public boolean isJavaDialect() {
        return JAVA_DIALECT.equalsIgnoreCase(this.dialect);
    }

    public boolean isMvelDialect() {
        return MVEL_DIALECT.equalsIgnoreCase(this.dialect);
    }

    public boolean isDefaultDialect() {
        return !this.isJavaDialect() && !this.isMvelDialect();
    }

    private void determineDialect(String string) {
        this.dialect = null;
        boolean bl = MVEL_DIALECT_PATTERN.matcher(string).matches();
        boolean bl2 = JAVA_DIALECT_PATTERN.matcher(string).matches();
        if (bl) {
            this.dialect = MVEL_DIALECT;
        } else if (bl2) {
            this.dialect = JAVA_DIALECT;
        }
    }

    public Location getLocation() {
        Location location = new Location(this.location);
        switch (this.location) {
            case 100: {
                Object object;
                int n = this.findToken("(", 100, this.locationIndex);
                if (n != -1 && (object = this.parserList.get(n - 1)) instanceof DroolsToken) {
                    String string = ((DroolsToken)object).getText();
                    location.setProperty("ClassName", (Object)string);
                }
                object = null;
                if (this.locationIndex + 1 < this.parserList.size()) {
                    object = "";
                }
                int n2 = this.locationIndex + 1;
                while (n2 < this.parserList.size()) {
                    Object object2;
                    if (!((object2 = this.parserList.get(n2++)) instanceof DroolsToken)) continue;
                    object = String.valueOf(object) + ((DroolsToken)object2).getText();
                }
                location.setProperty("PropertyName", object);
                break;
            }
            case 101: {
                String string;
                Object object;
                int n = this.findToken("(", 100, this.locationIndex);
                if (n != -1 && (object = this.parserList.get(n - 1)) instanceof DroolsToken) {
                    string = ((DroolsToken)object).getText();
                    location.setProperty("ClassName", (Object)string);
                }
                String string2 = null;
                n = this.findToken(100, this.locationIndex);
                if (n == -1) break;
                if (n + 1 < this.locationIndex) {
                    string2 = "";
                }
                int n3 = n + 1;
                while (n3 < this.locationIndex) {
                    if (!((object = this.parserList.get(n3++)) instanceof DroolsToken)) break;
                    string = ((DroolsToken)object).getText();
                    string2 = ":".equals(string) ? "" : String.valueOf(string2) + string;
                }
                location.setProperty("PropertyName", (Object)string2);
                break;
            }
            case 102: {
                Object object;
                Object object3;
                int n = this.findToken("(", 100, this.locationIndex);
                int n4 = this.findToken(101, this.locationIndex);
                int n5 = this.findToken(100, this.locationIndex);
                if (n != -1 && n4 != -1 && (object3 = this.parserList.get(n - 1)) instanceof DroolsToken) {
                    object = ((DroolsToken)object3).getText();
                    location.setProperty("ClassName", object);
                }
                object3 = "";
                int n6 = n4 + 1;
                while (n6 < this.locationIndex) {
                    object = this.parserList.get(n6);
                    if (object instanceof DroolsToken) {
                        object3 = String.valueOf(object3) + ((DroolsToken)object).getText();
                    }
                    if (n6 < this.locationIndex - 1) {
                        object3 = String.valueOf(object3) + " ";
                    }
                    ++n6;
                }
                location.setProperty("Operator", object3);
                String string = null;
                if (n == -1) break;
                if (n5 + 1 < this.locationIndex - 1) {
                    string = "";
                }
                n6 = n5 + 1;
                while (n6 < this.locationIndex - 1) {
                    if (!((object = this.parserList.get(n6++)) instanceof DroolsToken)) break;
                    String string3 = ((DroolsToken)object).getText();
                    string = ":".equals(string3) ? "" : String.valueOf(string) + string3;
                }
                location.setProperty("PropertyName", (Object)string);
                break;
            }
            case 103: {
                Object object;
                int n = this.findToken("(", 100, this.locationIndex);
                if (n == -1 || !((object = this.parserList.get(n - 1)) instanceof DroolsToken)) break;
                String string = ((DroolsToken)object).getText();
                location.setProperty("ClassName", (Object)string);
                break;
            }
            case 200: {
                String string = "";
                int n = this.locationIndex + 2;
                while (n < this.parserList.size()) {
                    Object object;
                    if (!((object = this.parserList.get(n++)) instanceof DroolsToken)) continue;
                    string = String.valueOf(string) + ((DroolsToken)object).getText();
                }
                location.setProperty("EvalContent", (Object)string);
                break;
            }
            case 300: {
                String string = null;
                if (this.locationIndex + 1 < this.parserList.size()) {
                    string = "";
                }
                int n = this.locationIndex + 1;
                while (n < this.parserList.size()) {
                    Object object;
                    if (!((object = this.parserList.get(n++)) instanceof DroolsToken)) continue;
                    string = String.valueOf(string) + ((DroolsToken)object).getText();
                }
                location.setProperty("FromContent", (Object)string);
                break;
            }
            case 304: {
                String string = "";
                int n = this.locationIndex + 1;
                while (n < this.parserList.size()) {
                    Object object;
                    if ((object = this.parserList.get(n++)) instanceof DroolsToken) {
                        string = String.valueOf(string) + ((DroolsToken)object).getText();
                    }
                    if (n >= this.parserList.size()) continue;
                    string = String.valueOf(string) + " ";
                }
                location.setProperty("FromAccumulateInitContent", (Object)string);
                break;
            }
            case 306: {
                Object object;
                int n;
                String string = "";
                int n7 = this.findToken(304, this.locationIndex);
                int n8 = this.findToken(305, this.locationIndex);
                if (n7 != -1 && n8 != -1) {
                    n = n7 + 1;
                    while (n < n8 - 2) {
                        object = this.parserList.get(n);
                        if (object instanceof DroolsToken) {
                            string = String.valueOf(string) + ((DroolsToken)object).getText();
                        }
                        if (n < n8 - 3) {
                            string = String.valueOf(string) + " ";
                        }
                        ++n;
                    }
                    location.setProperty("FromAccumulateInitContent", (Object)string);
                }
                string = "";
                n = this.locationIndex + 1;
                while (n < this.parserList.size()) {
                    if ((object = this.parserList.get(n++)) instanceof DroolsToken) {
                        string = String.valueOf(string) + ((DroolsToken)object).getText();
                    }
                    if (n >= this.parserList.size()) continue;
                    string = String.valueOf(string) + " ";
                }
                location.setProperty("FromAccumulateActionContent", (Object)string);
                break;
            }
            case 310: {
                Object object;
                int n;
                String string = "";
                int n9 = this.findToken(304, this.locationIndex);
                int n10 = this.findToken(305, this.locationIndex);
                int n11 = this.findToken(306, this.locationIndex);
                int n12 = this.findToken(307, this.locationIndex);
                if (n9 != -1 && n10 != -1) {
                    n = n9 + 1;
                    while (n < n10 - 2) {
                        object = this.parserList.get(n);
                        if (object instanceof DroolsToken) {
                            string = String.valueOf(string) + ((DroolsToken)object).getText();
                        }
                        if (n < n10 - 3) {
                            string = String.valueOf(string) + " ";
                        }
                        ++n;
                    }
                    location.setProperty("FromAccumulateInitContent", (Object)string);
                }
                string = "";
                if (n11 != -1 && n12 != -1) {
                    n = n11 + 1;
                    while (n < n12 - 2) {
                        object = this.parserList.get(n);
                        if (object instanceof DroolsToken) {
                            string = String.valueOf(string) + ((DroolsToken)object).getText();
                        }
                        if (n < n12 - 3) {
                            string = String.valueOf(string) + " ";
                        }
                        ++n;
                    }
                    location.setProperty("FromAccumulateActionContent", (Object)string);
                }
                string = "";
                n = this.locationIndex + 1;
                while (n < this.parserList.size()) {
                    if ((object = this.parserList.get(n++)) instanceof DroolsToken) {
                        string = String.valueOf(string) + ((DroolsToken)object).getText();
                    }
                    if (n >= this.parserList.size()) continue;
                    string = String.valueOf(string) + " ";
                }
                location.setProperty("FromAccumulateResultContent", (Object)string);
                break;
            }
            case 1000: {
                String string = "";
                int n = this.locationIndex + 1;
                int n13 = 0x7FFFFFFE;
                while (n < this.parserList.size()) {
                    Object object;
                    if (!((object = this.parserList.get(n++)) instanceof DroolsToken)) continue;
                    DroolsToken droolsToken = (DroolsToken)object;
                    if (n13 + 1 < droolsToken.getStartIndex()) {
                        string = String.valueOf(string) + " ";
                    }
                    string = String.valueOf(string) + droolsToken.getText();
                    n13 = droolsToken.getStopIndex();
                }
                location.setProperty("RHSContent", (Object)string);
                break;
            }
            case 2000: {
                String string = "";
                int n = this.locationIndex + 1;
                while (n < this.parserList.size()) {
                    Object object;
                    if (!((object = this.parserList.get(n++)) instanceof DroolsToken)) continue;
                    string = String.valueOf(string) + ((DroolsToken)object).getText();
                }
                location.setProperty("HeaderContent", (Object)string);
                break;
            }
            case 2001: {
                Object object;
                int n;
                String string = "";
                int n14 = this.findToken(2000, this.locationIndex);
                if (n14 != -1) {
                    n = n14 + 1;
                    while (n < this.locationIndex) {
                        object = this.parserList.get(n);
                        if (object instanceof DroolsToken) {
                            string = String.valueOf(string) + ((DroolsToken)object).getText();
                        }
                        ++n;
                    }
                }
                if (this.locationIndex + 1 < this.parserList.size()) {
                    string = String.valueOf(string) + " ";
                }
                n = this.locationIndex + 1;
                while (n < this.parserList.size()) {
                    if ((object = this.parserList.get(n++)) instanceof DroolsToken) {
                        string = String.valueOf(string) + ((DroolsToken)object).getText();
                    }
                    if (n == this.parserList.size()) continue;
                    string = String.valueOf(string) + " ";
                }
                location.setProperty("HeaderContent", (Object)string);
            }
        }
        return location;
    }

    public String getRuleName() {
        Object object;
        if (this.parserList.size() >= 2 && (object = this.parserList.get(1)) instanceof DroolsToken) {
            String string = ((DroolsToken)object).getText();
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    public Map<String, String[]> getRuleParameters() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        int n = 0;
        int n2 = -1;
        for (Object e : this.parserList) {
            if (e instanceof DroolsToken) {
                DroolsToken droolsToken = (DroolsToken)e;
                if (DroolsEditorType.IDENTIFIER_VARIABLE.equals((Object)droolsToken.getEditorType())) {
                    Object object;
                    Object object2;
                    int n3;
                    String string = droolsToken.getText();
                    if (n2 == 1) {
                        n3 = n + 2;
                        String string2 = "";
                        while (n3 < this.parserList.size()) {
                            if (!((object2 = this.parserList.get(n3++)) instanceof DroolsToken)) continue;
                            object = ((DroolsToken)object2).getText();
                            if ("(".equals(object)) {
                                String[] stringArray = new String[2];
                                stringArray[0] = string2;
                                hashMap.put(string, stringArray);
                                break;
                            }
                            string2 = String.valueOf(string2) + (String)object;
                        }
                    } else if (n2 == 100) {
                        Object object3;
                        n3 = this.findToken(1, n);
                        int n4 = n3 + 3;
                        object2 = "";
                        while (n4 < n) {
                            if (!((object = this.parserList.get(n4++)) instanceof DroolsToken)) continue;
                            object3 = ((DroolsToken)object).getText();
                            if ("(".equals(object3)) break;
                            object2 = String.valueOf(object2) + (String)object3;
                        }
                        n4 = n + 2;
                        object = "";
                        while (n4 < this.parserList.size()) {
                            if ((object3 = this.parserList.get(n4++)) instanceof DroolsToken) {
                                String string3 = ((DroolsToken)object3).getText();
                                if (",".equals(string3) || ")".equals(string3)) {
                                    hashMap.put(string, new String[]{object2, object});
                                    break;
                                }
                                object = String.valueOf(object) + string3;
                                continue;
                            }
                            hashMap.put(string, new String[]{object2, object});
                        }
                    }
                }
            } else if (e instanceof Integer) {
                n2 = (Integer)e;
            }
            ++n;
        }
        return hashMap;
    }

    private int findToken(String string, int n, int n2) {
        int n3 = n2 - 1;
        while (n3 >= 0) {
            Object object = this.parserList.get(n3);
            if (object instanceof DroolsToken && "(".equals(((DroolsToken)object).getText()) && (object = this.parserList.get(n3 + 1)) instanceof Integer && n == (Integer)object) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    private int findToken(int n, int n2) {
        int n3 = n2 - 1;
        while (n3 >= 0) {
            Object object = this.parserList.get(n3);
            if (object instanceof Integer && n == (Integer)object) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    private void deriveLocation() {
        this.location = -1;
        int n = 0;
        for (Object e : this.parserList) {
            if (e instanceof Integer) {
                this.location = (Integer)e;
                this.locationIndex = n;
            }
            ++n;
        }
    }

    private DRLParser getParser(String string) {
        DRLParser dRLParser = new DRLParser((TokenStream)new CommonTokenStream((TokenSource)new DRLLexer((CharStream)new ANTLRStringStream(string))));
        dRLParser.setTreeAdaptor((TreeAdaptor)new DroolsTreeAdaptor());
        dRLParser.enableEditorInterface();
        return dRLParser;
    }
}

