/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.Signature;

public class CompletionUtil {
    protected static final Pattern INCOMPLETED_MVEL_EXPRESSION = Pattern.compile("[\\.\\(\\{\\[]\\Z", 32);
    protected static final Pattern COMPLETED_MVEL_EXPRESSION = Pattern.compile("]\\)\\}\\]\\Z", 32);
    protected static final Pattern MODIFY_PATTERN = Pattern.compile(".*modify\\s*\\(\\s*(.*)\\s*\\)(\\s*\\{(.*)\\s*\\}?)?", 32);
    protected static final Pattern START_OF_NEW_JAVA_STATEMENT = Pattern.compile(".*[;{}]\\s*", 32);
    protected static final Pattern START_OF_METHOD_ARGS = Pattern.compile(".*[\\(]\\s*", 32);

    private CompletionUtil() {
    }

    public static String stripLastWord(String string) {
        if ("".equals(string)) {
            return string;
        }
        if (string.charAt(string.length() - 1) == ' ') {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            if (Character.isWhitespace(cArray[n2]) || cArray[n2] == '(' || cArray[n2] == ':' || cArray[n2] == ';' || cArray[n2] == '=' || cArray[n2] == '<' || cArray[n2] == '>' || cArray[n2] == '.' || cArray[n2] == '{' || cArray[n2] == '}') {
                n = n2 + 1;
                break;
            }
            --n2;
        }
        string = string.substring(n, string.length());
        return string;
    }

    public static String getPreviousExpression(String string) {
        int n = string.lastIndexOf(59);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n + 1);
    }

    public static String getLastExpression(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2.trim().length() == 0) {
            return string;
        }
        return string2;
    }

    public static String getInnerExpression(String string) {
        String string2 = CompletionUtil.getLastExpression(string).trim();
        char[] cArray = string2.toCharArray();
        int n = 0;
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            if (Character.isWhitespace(cArray[n2]) || cArray[n2] == '(' || cArray[n2] == '+' || cArray[n2] == ')' || cArray[n2] == '[' || cArray[n2] == ']' || cArray[n2] == ':' || cArray[n2] == '=' || cArray[n2] == '<' || cArray[n2] == '>' || cArray[n2] == ',' || cArray[n2] == '{' || cArray[n2] == '}') {
                n = n2 + 1;
                break;
            }
            --n2;
        }
        string2 = string2.substring(n);
        return string2;
    }

    public static int nestedExpressionIndex(char[] cArray, int n, char c) {
        int n2 = 1;
        char c2 = c;
        switch (c) {
            case '[': {
                c2 = ']';
                break;
            }
            case '{': {
                c2 = '}';
                break;
            }
            case '(': {
                c2 = ')';
            }
        }
        if (c == c2) {
            ++n;
            while (n < cArray.length) {
                if (cArray[n] == c) {
                    return n;
                }
                ++n;
            }
        } else {
            ++n;
            while (n < cArray.length) {
                if (cArray[n] != '\'' && cArray[n] != '\"') {
                    if (cArray[n] == c) {
                        ++n2;
                    } else if (cArray[n] == c2 && --n2 == 0) {
                        return n;
                    }
                }
                ++n;
            }
        }
        return -1;
    }

    public static String stripWhiteSpace(String string) {
        if ("".equals(string)) {
            return string;
        }
        if (string.charAt(string.length() - 1) == ' ') {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            if (Character.isWhitespace(cArray[n2])) {
                n = n2 + 1;
                break;
            }
            --n2;
        }
        string = string.substring(n, string.length());
        return string;
    }

    public static String getCompilableText(String string) {
        String string2 = string.trim();
        if (string2.endsWith(";")) {
            return string.substring(0, string.length() - 1);
        }
        if (string2.endsWith(".") || string2.endsWith(",")) {
            return string.substring(0, string.length() - 1);
        }
        if (COMPLETED_MVEL_EXPRESSION.matcher(string).matches()) {
            return String.valueOf(string) + ";";
        }
        return string;
    }

    public static boolean isGetter(String string, int n, String string2) {
        return CompletionUtil.isAccessor(string, n, 0, "get", string2, "V", false);
    }

    public static boolean isSetter(String string, int n, String string2) {
        return CompletionUtil.isAccessor(string, n, 1, "set", string2, "V", true);
    }

    public static boolean isIsGetter(String string, int n, String string2) {
        return CompletionUtil.isAccessor(string, n, 0, "is", string2, "Z", true);
    }

    public static String getPropertyName(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = string.replaceAll("\\(\\)", "");
        int n2 = 0;
        if (CompletionUtil.isIsGetter(string3, n, string2)) {
            n2 = 2;
        } else if (CompletionUtil.isGetter(string3, n, string2) || CompletionUtil.isSetter(string3, n, string2)) {
            n2 = 3;
        } else {
            return string;
        }
        char c = Character.toLowerCase(string3.charAt(n2));
        String string4 = String.valueOf(c) + string3.substring(n2 + 1);
        return string4;
    }

    public static String getPropertyName(String string, char[] cArray) {
        if (cArray == null || string == null) {
            return string;
        }
        int n = Signature.getParameterCount((char[])cArray);
        String string2 = new String(Signature.getReturnType((char[])cArray));
        return CompletionUtil.getPropertyName(string, n, string2);
    }

    public static String getWritablePropertyName(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = string.replaceAll("\\(\\)", "");
        if (!CompletionUtil.isSetter(string3, n, string2)) {
            return string;
        }
        int n2 = 3;
        char c = Character.toLowerCase(string3.charAt(n2));
        String string4 = String.valueOf(c) + string3.substring(n2 + 1);
        return string4;
    }

    public static String getWritablePropertyName(String string, char[] cArray) {
        if (cArray == null || string == null) {
            return string;
        }
        int n = Signature.getParameterCount((char[])cArray);
        String string2 = new String(Signature.getReturnType((char[])cArray));
        return CompletionUtil.getWritablePropertyName(string, n, string2);
    }

    private static boolean isAccessor(String string, int n, int n2, String string2, String string3, String string4, boolean bl) {
        if (string.length() < string2.length() + 1) {
            return false;
        }
        if (!string.startsWith(string2)) {
            return false;
        }
        if (n != n2) {
            return false;
        }
        return !(bl ? !string4.equals(string3) : string4.equals(string3));
    }

    public static boolean isStartOfNewStatement(String string, String string2) {
        String string3 = string.substring(0, string.length() - string2.length());
        return "".equals(string3.trim()) || START_OF_NEW_JAVA_STATEMENT.matcher(string3).matches();
    }

    public static String getLastLine(String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = null;
        String string3 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() <= 0) continue;
                string3 = string2;
            }
        }
        catch (IOException iOException) {}
        return string3;
    }

    public static String getSimpleClassName(Class clazz) {
        int n = clazz.getName().lastIndexOf(36);
        if (n < 0) {
            n = clazz.getName().lastIndexOf(46);
        }
        if (clazz.isArray()) {
            return String.valueOf(clazz.getName().substring(n + 1)) + "[]";
        }
        return clazz.getName().substring(n + 1);
    }

    public static String getTextWithoutPrefix(String string, String string2) {
        int n = string.length() - string2.length();
        String string3 = string;
        if (n >= 0) {
            string3 = string.substring(0, n);
        }
        return string3;
    }

    public static boolean isStartOfDialectExpression(String string) {
        return "".equals(string.trim()) || START_OF_NEW_JAVA_STATEMENT.matcher(string).matches();
    }

    public static boolean isStartOfMethodArgsExpression(String string) {
        return START_OF_NEW_JAVA_STATEMENT.matcher(string).matches();
    }
}

