/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class RuleCompletionProposal
implements ICompletionProposal {
    private String content;
    private String display;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private int priority;

    public RuleCompletionProposal(int n, int n2, String string) {
        this(n, n2, string, string);
    }

    public RuleCompletionProposal(int n, int n2, String string, String string2) {
        this(n, n2, string, string2, string2.length());
    }

    public RuleCompletionProposal(int n, int n2, String string, String string2, Image image) {
        this(n, n2, string, string2, string2.length(), image);
    }

    public RuleCompletionProposal(int n, int n2, String string, String string2, int n3) {
        this(n, n2, string, string2, n3, null);
    }

    public RuleCompletionProposal(int n, int n2, String string, String string2, int n3, Image image) {
        this.replacementOffset = n;
        this.replacementLength = n2;
        this.content = string2;
        this.display = string;
        this.cursorPosition = n3;
        this.image = image;
    }

    public String getDisplay() {
        return this.display;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public Image getImage() {
        return this.image;
    }

    public String getContent() {
        return this.content;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public String toString() {
        return this.content;
    }

    public void apply(IDocument iDocument) {
        try {
            iDocument.replace(this.replacementOffset, this.replacementLength, this.content);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        if (this.display != null) {
            return this.display;
        }
        return this.content;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.content == null ? 0 : this.content.hashCode());
        n = 31 * n + (this.display == null ? 0 : this.display.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RuleCompletionProposal ruleCompletionProposal = (RuleCompletionProposal)object;
        if (this.content == null ? ruleCompletionProposal.content != null : !this.content.equals(ruleCompletionProposal.content)) {
            return false;
        }
        return !(this.display == null ? ruleCompletionProposal.display != null : !this.display.equals(ruleCompletionProposal.display));
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.replacementOffset + this.cursorPosition, 0);
    }

    public static class RuleCompletionProposalComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof RuleCompletionProposal) {
                if (object2 instanceof RuleCompletionProposal) {
                    RuleCompletionProposal ruleCompletionProposal = (RuleCompletionProposal)object;
                    RuleCompletionProposal ruleCompletionProposal2 = (RuleCompletionProposal)object2;
                    if (ruleCompletionProposal.getPriority() == ruleCompletionProposal2.getPriority()) {
                        return ruleCompletionProposal.display.compareTo(ruleCompletionProposal2.display);
                    }
                    if (ruleCompletionProposal.getPriority() > ruleCompletionProposal2.getPriority()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (object2 instanceof RuleCompletionProposal) {
                return 1;
            }
            return 0;
        }
    }
}

