/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.outline;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.DroolsParserException;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.core.DroolsElement;
import org.drools.eclipse.core.DroolsModelBuilder;
import org.drools.eclipse.core.Package;
import org.drools.eclipse.core.RuleSet;
import org.drools.eclipse.core.ui.DroolsContentProvider;
import org.drools.eclipse.core.ui.DroolsGroupByRuleGroupContentProvider;
import org.drools.eclipse.core.ui.DroolsLabelProvider;
import org.drools.eclipse.core.ui.DroolsTreeSorter;
import org.drools.eclipse.core.ui.FilterActionGroup;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleContentOutlinePage
extends ContentOutlinePage {
    private AbstractRuleEditor editor;
    private RuleSet ruleSet = DroolsModelBuilder.createRuleSet();
    private Map<String, RuleDescr> rules;
    private boolean groupByRulegroup = false;
    private TreeViewer viewer = null;
    private static final Pattern RULE_PATTERN1 = Pattern.compile("\\n\\s*rule\\s+\"([^\"]+)\"", 32);
    private static final Pattern RULE_PATTERN2 = Pattern.compile("\\n\\s*rule\\s+([^\\s;#\"]+)", 32);
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("\\s*package\\s+([^\\s;#]+);?", 32);
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\n\\s*function\\s+(\\S+)\\s+(\\S+)\\(.*?\\)", 32);
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\n\\s*template\\s+([^\\s;#\"]+)", 32);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("\\n\\s*import\\s+([^\\s;#]+);?", 32);
    private static final Pattern EXPANDER_PATTERN = Pattern.compile("\\n\\s*expander\\s+([^\\s;#]+);?", 32);
    private static final Pattern GLOBAL_PATTERN = Pattern.compile("\\n\\s*global\\s+(\\S+)\\s+([^\\s;#]+);?", 32);
    private static final Pattern QUERY_PATTERN1 = Pattern.compile("\\n\\s*query\\s+\"([^\"]+)\"", 32);
    private static final Pattern QUERY_PATTERN2 = Pattern.compile("\\n\\s*query\\s+([^\\s;#\"]+)", 32);
    DroolsContentProvider contentProvider = null;
    DroolsGroupByRuleGroupContentProvider groupByRuleGroupContentProvider = null;

    public RuleContentOutlinePage(AbstractRuleEditor abstractRuleEditor) {
        this.editor = abstractRuleEditor;
    }

    private void setContentProvider() {
        IPreferenceStore iPreferenceStore = DroolsEclipsePlugin.getDefault().getPreferenceStore();
        this.groupByRulegroup = iPreferenceStore.getBoolean("GroupByRuleGroupAction.isChecked");
        this.contentProvider = new DroolsContentProvider();
        this.groupByRuleGroupContentProvider = new DroolsGroupByRuleGroupContentProvider();
        if (this.groupByRulegroup) {
            this.viewer.setContentProvider((IContentProvider)this.groupByRuleGroupContentProvider);
        } else {
            this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        }
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.viewer = this.getTreeViewer();
        this.setContentProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DroolsLabelProvider());
        this.viewer.setSorter((ViewerSorter)new DroolsTreeSorter());
        this.viewer.setInput((Object)this.ruleSet);
        FilterActionGroup filterActionGroup = new FilterActionGroup((StructuredViewer)this.viewer, "org.drools.eclipse.editors.outline.RuleContentOutlinePage");
        filterActionGroup.fillActionBars(this.getSite().getActionBars());
        this.update();
        super.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection;
                DroolsElement droolsElement;
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection != null && iSelection instanceof StructuredSelection && (droolsElement = (DroolsElement)(structuredSelection = (StructuredSelection)iSelection).getFirstElement()) != null) {
                    RuleContentOutlinePage.this.editor.selectAndReveal(droolsElement.getOffset(), droolsElement.getLength());
                }
            }
        });
    }

    public void update() {
        Control control;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (control = treeViewer.getControl()) != null && !control.isDisposed()) {
            this.initRules();
            this.populatePackageTreeNode();
            treeViewer.refresh();
            control.setRedraw(false);
            treeViewer.expandToLevel(2);
            control.setRedraw(true);
        }
    }

    public void populatePackageTreeNode() {
        String string = this.editor.getContent();
        this.populatePackageTreeNode(string);
    }

    void populatePackageTreeNode(String string) {
        Object object;
        String string2;
        DroolsModelBuilder.clearRuleSet(this.ruleSet);
        Matcher matcher = PACKAGE_PATTERN.matcher(string);
        String string3 = null;
        int n = 0;
        int n2 = 0;
        if (matcher.find()) {
            string3 = matcher.group(1);
            n = matcher.start(1);
            n2 = matcher.end(1);
        }
        Package package_ = DroolsModelBuilder.addPackage(this.ruleSet, string3, n, n2 - n);
        matcher = RULE_PATTERN1.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            object = this.rules.get(string2);
            if (object == null) continue;
            DroolsModelBuilder.addRule(package_, string2, null, matcher.start(1), matcher.end(1) - matcher.start(1), this.extractAttributes((RuleDescr)object));
        }
        matcher = RULE_PATTERN2.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            object = this.rules.get(string2);
            if (object == null) continue;
            DroolsModelBuilder.addRule(package_, string2, null, matcher.start(1), matcher.end(1) - matcher.start(1), this.extractAttributes((RuleDescr)object));
        }
        matcher = FUNCTION_PATTERN.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            DroolsModelBuilder.addFunction(package_, String.valueOf(string2) + "()", null, matcher.start(2), matcher.end(2) - matcher.start(2));
        }
        matcher = EXPANDER_PATTERN.matcher(string);
        if (matcher.find()) {
            string2 = matcher.group(1);
            DroolsModelBuilder.addExpander(package_, string2, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = IMPORT_PATTERN.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            DroolsModelBuilder.addImport(package_, string2, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = GLOBAL_PATTERN.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            object = matcher.group(2);
            String string4 = String.valueOf(object) + " : " + string2;
            DroolsModelBuilder.addGlobal(package_, string4, null, matcher.start(2), matcher.end(2) - matcher.start(2));
        }
        matcher = QUERY_PATTERN1.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            DroolsModelBuilder.addQuery(package_, string2, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = QUERY_PATTERN2.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            DroolsModelBuilder.addQuery(package_, string2, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
        matcher = TEMPLATE_PATTERN.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            DroolsModelBuilder.addTemplate(package_, string2, null, matcher.start(1), matcher.end(1) - matcher.start(1));
        }
    }

    RuleSet getRuleSet() {
        return this.ruleSet;
    }

    private Map<String, String> extractAttributes(RuleDescr ruleDescr) {
        HashMap<String, String> hashMap = null;
        if (ruleDescr != null) {
            hashMap = new HashMap<String, String>();
            for (AttributeDescr attributeDescr : ruleDescr.getAttributes().values()) {
                if (attributeDescr == null || attributeDescr.getName() == null) continue;
                hashMap.put(attributeDescr.getName(), attributeDescr.getValue());
            }
        }
        return hashMap;
    }

    public void initRules() {
        this.rules = new HashMap<String, RuleDescr>();
        try {
            PackageDescr packageDescr;
            DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseResource(this.editor, true, false);
            if (dRLInfo != null && (packageDescr = dRLInfo.getPackageDescr()) != null) {
                for (RuleDescr ruleDescr : packageDescr.getRules()) {
                    this.rules.put(ruleDescr.getName(), ruleDescr);
                }
            }
        }
        catch (DroolsParserException droolsParserException) {
            DroolsEclipsePlugin.log(droolsParserException);
        }
    }

    public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
        GroupByRuleGroupAction groupByRuleGroupAction = new GroupByRuleGroupAction();
        iMenuManager.add((IAction)groupByRuleGroupAction);
        super.makeContributions(iMenuManager, iToolBarManager, iStatusLineManager);
    }

    class GroupByRuleGroupAction
    extends Action {
        public GroupByRuleGroupAction() {
            this.setText("Group by Rule Group");
            this.setToolTipText("Group by Rule Group");
            this.setDescription("Group by agenda-group, activation-group or ruleflow-group");
            this.setChecked(RuleContentOutlinePage.this.groupByRulegroup);
        }

        public void run() {
            this.setGroupByRuleGroup(!RuleContentOutlinePage.this.groupByRulegroup);
        }

        private void setGroupByRuleGroup(boolean bl) {
            RuleContentOutlinePage.this.groupByRulegroup = bl;
            this.setChecked(bl);
            IPreferenceStore iPreferenceStore = DroolsEclipsePlugin.getDefault().getPreferenceStore();
            iPreferenceStore.setValue("GroupByRuleGroupAction.isChecked", bl);
            RuleContentOutlinePage.this.setContentProvider();
            RuleContentOutlinePage.this.viewer.refresh(true);
        }
    }
}

