/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.commands;

import org.drools.reteoo.BaseVertex;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class NodeSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final BaseVertex vertex;

    public NodeSetConstraintCommand(BaseVertex baseVertex, ChangeBoundsRequest changeBoundsRequest, Rectangle rectangle) {
        if (baseVertex == null || changeBoundsRequest == null || rectangle == null) {
            throw new IllegalArgumentException();
        }
        this.vertex = baseVertex;
        this.request = changeBoundsRequest;
        this.newBounds = rectangle.getCopy();
    }

    public boolean canExecute() {
        Object object = this.request.getType();
        return "move".equals(object) || "move children".equals(object);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.vertex.getLocation(), this.vertex.getSize());
        this.redo();
    }

    public void redo() {
        this.vertex.setSize(this.newBounds.getSize());
        this.vertex.setLocation(this.newBounds.getLocation());
    }

    public void undo() {
        this.vertex.setSize(this.oldBounds.getSize());
        this.vertex.setLocation(this.oldBounds.getLocation());
    }
}

