/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.reteoo.AccumulateNodeVertex;
import org.drools.reteoo.AlphaNodeVertex;
import org.drools.reteoo.BaseVertex;
import org.drools.reteoo.EntryPointNodeVertex;
import org.drools.reteoo.EvalConditionNodeVertex;
import org.drools.reteoo.ExistsNodeVertex;
import org.drools.reteoo.FromNodeVertex;
import org.drools.reteoo.JoinNodeVertex;
import org.drools.reteoo.LeftInputAdapterNodeVertex;
import org.drools.reteoo.NotNodeVertex;
import org.drools.reteoo.ObjectTypeNodeVertex;
import org.drools.reteoo.PropagationQueuingNodeVertex;
import org.drools.reteoo.QueryTerminalNodeVertex;
import org.drools.reteoo.ReteVertex;
import org.drools.reteoo.RightInputAdapterNodeVertex;
import org.drools.reteoo.RuleTerminalNodeVertex;
import org.drools.spi.Constraint;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class VertexPropertySource
implements IPropertySource {
    private static final String VERTEX_FROM = "From BaseVertex";
    private static final String VERTEX_ACCUMULATE = "Accumulate BaseVertex";
    private static final String VERTEX_COLLECT = "Collect BaseVertex";
    private static final String VERTEX_EXISTS = "Exists BaseVertex";
    private static final String VERTEX_TERMINAL = "Terminal BaseVertex";
    private static final String VERTEX_QUERY_TERMINAL = "Query Terminal BaseVertex";
    private static final String VERTEX_EVAL_CONDITION = "Eval Condition BaseVertex";
    private static final String VERTEX_NOT = "Not BaseVertex";
    private static final String VERTEX_JOIN = "Join BaseVertex";
    private static final String VERTEX_RIGHT_INPUT_ADAPTER = "Right Input Adapter BaseVertex";
    private static final String VERTEX_LEFT_INPUT_ADAPTER = "Left Input Adapter BaseVertex";
    private static final String VERTEX_ALPHA = "Alpha BaseVertex";
    private static final String VERTEX_OBJECT_TYPE = "Object Type BaseVertex";
    private static final String VERTEX_RETE = "Rete BaseVertex";
    private static final String VERTEX_ENTRY_POINT = "Entry Point BaseVertex";
    private static final String VERTEX_PROPAGATION_QUEUING = "Propagation Queuing BaseVertex";
    private static final String CONSTRAINT_CAP = "Constraint";
    private static final String CONSTRAINT = "constraint";
    public String ID_ROOT = "vertex";
    public String ID_ID = "id";
    public String ID_HTML = "html";
    private IPropertyDescriptor[] descriptors;
    private final IPropertyDescriptor PROP_NAME = new PropertyDescriptor((Object)"name", "\u540d\u524d");
    private final IPropertyDescriptor PROP_ID = new PropertyDescriptor((Object)"id", "ID");
    private final IPropertyDescriptor PROP_RULE = new PropertyDescriptor((Object)"rule", "\u30eb\u30fc\u30eb");
    private final IPropertyDescriptor PROP_QUERY = new PropertyDescriptor((Object)"query", "\u30af\u30a8\u30ea\u30fc");
    private final IPropertyDescriptor PROP_ALPHA_FIELD_NAME = new PropertyDescriptor((Object)"fieldName", "\u30d5\u30a3\u30fc\u30eb\u30c9\u540d");
    private final IPropertyDescriptor PROP_ALPHA_EVALUATOR = new PropertyDescriptor((Object)"evaluator", "\u8a55\u4fa1\u8005");
    private final IPropertyDescriptor PROP_ALPHA_VALUE = new PropertyDescriptor((Object)"value", "\u5024");
    private final IPropertyDescriptor PROP_OBJ_TYPE = new PropertyDescriptor((Object)"objectType", "\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30bf\u30a4\u30d7");
    private final IPropertyDescriptor PROP_EXP_OFFSET = new PropertyDescriptor((Object)"expirationOffset", "\u6709\u52b9\u30aa\u30d5\u30bb\u30c3\u30c8");
    private final IPropertyDescriptor PROP_ENTRY_POINT_NAME = new PropertyDescriptor((Object)"entryPointName", "\u30a8\u30f3\u30c8\u30ea\u30dd\u30a4\u30f3\u30c8\u540d");
    private static final String CAT_GENERAL = "General";
    private static final String CAT_OTHER = "Other";
    protected BaseVertex vertex = null;
    private Map values = new HashMap();

    public VertexPropertySource(BaseVertex baseVertex) {
        this.vertex = baseVertex;
        this.initProperties(baseVertex);
    }

    private final void initProperties(BaseVertex baseVertex) {
        ArrayList arrayList = new ArrayList();
        if (baseVertex instanceof ExistsNodeVertex) {
            this.initExistsNodeProperties((ExistsNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof FromNodeVertex) {
            this.initFromNodeProperties((FromNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof AccumulateNodeVertex) {
            this.initAccumulateNodeProperties((AccumulateNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof RuleTerminalNodeVertex) {
            this.initTerminalNodeProperties((RuleTerminalNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof QueryTerminalNodeVertex) {
            this.initQueryTerminalNodeProperties((QueryTerminalNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof EvalConditionNodeVertex) {
            this.initEvalConditionNodeProperties((EvalConditionNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof NotNodeVertex) {
            this.initNotNodeProperties((NotNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof JoinNodeVertex) {
            this.initJoinNodeProperties((JoinNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof RightInputAdapterNodeVertex) {
            this.initRightInputAdapterNodeProperties(arrayList, this.values);
        } else if (baseVertex instanceof LeftInputAdapterNodeVertex) {
            this.initLeftInputAdapterNodeProperties((LeftInputAdapterNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof AlphaNodeVertex) {
            this.initAlphaNodeProperties((AlphaNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof ObjectTypeNodeVertex) {
            this.initObjectTypeNodeProperties((ObjectTypeNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof ReteVertex) {
            this.initReteNodeProperties((ReteVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof PropagationQueuingNodeVertex) {
            this.initPropagationQueuingNodeProperties((PropagationQueuingNodeVertex)baseVertex, arrayList, this.values);
        } else if (baseVertex instanceof EntryPointNodeVertex) {
            this.initEntryPointNodeProperties((EntryPointNodeVertex)baseVertex, arrayList, this.values);
        }
        this.descriptors = arrayList.toArray(new IPropertyDescriptor[0]);
    }

    private void initExistsNodeProperties(ExistsNodeVertex existsNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_EXISTS, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(existsNodeVertex.getId()), list, map);
    }

    private void initAccumulateNodeProperties(AccumulateNodeVertex accumulateNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_ACCUMULATE, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(accumulateNodeVertex.getId()), list, map);
    }

    private void initFromNodeProperties(FromNodeVertex fromNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_FROM, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(fromNodeVertex.getId()), list, map);
    }

    private void initReteNodeProperties(ReteVertex reteVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_RETE, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(reteVertex.getId()), list, map);
    }

    private void initObjectTypeNodeProperties(ObjectTypeNodeVertex objectTypeNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_OBJECT_TYPE, list, map);
        this.addProperty(this.PROP_OBJ_TYPE, objectTypeNodeVertex.getObjectType(), list, map);
        this.addProperty(this.PROP_EXP_OFFSET, objectTypeNodeVertex.getExpirationOffset(), list, map);
    }

    private void initAlphaNodeProperties(AlphaNodeVertex alphaNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_ALPHA, list, map);
        this.addProperty(this.PROP_ALPHA_FIELD_NAME, alphaNodeVertex.getFieldName(), list, map);
        this.addProperty(this.PROP_ALPHA_EVALUATOR, alphaNodeVertex.getEvaluator(), list, map);
        this.addProperty(this.PROP_ALPHA_VALUE, alphaNodeVertex.getValue(), list, map);
        Constraint constraint = alphaNodeVertex.getConstraint();
        if (constraint == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)CONSTRAINT, CONSTRAINT_CAP);
        this.addProperty((IPropertyDescriptor)propertyDescriptor, constraint.toString(), list, map);
    }

    private void initLeftInputAdapterNodeProperties(LeftInputAdapterNodeVertex leftInputAdapterNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_LEFT_INPUT_ADAPTER, list, map);
    }

    private void initRightInputAdapterNodeProperties(List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_RIGHT_INPUT_ADAPTER, list, map);
    }

    private void initJoinNodeProperties(JoinNodeVertex joinNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_JOIN, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(joinNodeVertex.getId()), list, map);
        Constraint[] constraintArray = joinNodeVertex.getConstraints();
        if (constraintArray == null) {
            return;
        }
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)(CONSTRAINT + (n + 1)), "Constraint " + (n + 1));
            this.addOther((IPropertyDescriptor)propertyDescriptor, constraintArray[n].toString(), list, map);
            ++n;
        }
    }

    private void initNotNodeProperties(NotNodeVertex notNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_NOT, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(notNodeVertex.getId()), list, map);
    }

    private void initEvalConditionNodeProperties(EvalConditionNodeVertex evalConditionNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_EVAL_CONDITION, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(evalConditionNodeVertex.getId()), list, map);
    }

    private void initTerminalNodeProperties(RuleTerminalNodeVertex ruleTerminalNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_TERMINAL, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(ruleTerminalNodeVertex.getId()), list, map);
        this.addProperty(this.PROP_RULE, ruleTerminalNodeVertex.getRuleName(), list, map);
    }

    private void initQueryTerminalNodeProperties(QueryTerminalNodeVertex queryTerminalNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_QUERY_TERMINAL, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(queryTerminalNodeVertex.getId()), list, map);
        this.addProperty(this.PROP_QUERY, queryTerminalNodeVertex.getQueryName(), list, map);
    }

    private void initPropagationQueuingNodeProperties(PropagationQueuingNodeVertex propagationQueuingNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_PROPAGATION_QUEUING, list, map);
        this.addProperty(this.PROP_ID, Integer.toString(propagationQueuingNodeVertex.getId()), list, map);
    }

    private void initEntryPointNodeProperties(EntryPointNodeVertex entryPointNodeVertex, List list, Map map) {
        this.addProperty(this.PROP_NAME, VERTEX_ENTRY_POINT, list, map);
        this.addProperty(this.PROP_ENTRY_POINT_NAME, entryPointNodeVertex.getEntryPointName(), list, map);
        this.addProperty(this.PROP_ID, Integer.toString(entryPointNodeVertex.getId()), list, map);
    }

    private void addProperty(IPropertyDescriptor iPropertyDescriptor, String string, List list, Map map) {
        list.add(iPropertyDescriptor);
        map.put(iPropertyDescriptor.getId().toString(), new NodeValue(CAT_GENERAL, string));
        if (iPropertyDescriptor instanceof PropertyDescriptor) {
            ((PropertyDescriptor)iPropertyDescriptor).setAlwaysIncompatible(true);
            ((PropertyDescriptor)iPropertyDescriptor).setCategory(CAT_GENERAL);
        }
    }

    private void addOther(IPropertyDescriptor iPropertyDescriptor, String string, List list, Map map) {
        list.add(iPropertyDescriptor);
        map.put(iPropertyDescriptor.getId().toString(), new NodeValue(CAT_OTHER, string));
        if (iPropertyDescriptor instanceof PropertyDescriptor) {
            ((PropertyDescriptor)iPropertyDescriptor).setAlwaysIncompatible(true);
            ((PropertyDescriptor)iPropertyDescriptor).setCategory(CAT_OTHER);
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public Object getPropertyValue(Object object) {
        return this.getPropertyValue((String)object);
    }

    public Object getPropertyValue(String string) {
        return ((NodeValue)this.values.get((Object)string)).value;
    }

    public void setPropertyValue(Object object, Object object2) {
        this.setPropertyValue(object, object2);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public void resetPropertyValue(Object object) {
    }

    public boolean isPropertySet(Object object) {
        return this.values.containsKey(object);
    }

    private class NodeValue {
        final String category;
        final String value;

        NodeValue(String string, String string2) {
            this.category = string;
            this.value = string2;
        }
    }
}

