/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.scanners;

import java.util.ArrayList;
import org.drools.eclipse.editors.ColorManager;
import org.drools.eclipse.editors.Keywords;
import org.drools.eclipse.editors.scanners.RuleWordDetector;
import org.drools.eclipse.editors.scanners.WhitespaceDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;

public class DRLScanner
extends RuleBasedScanner {
    private static final Color KEYWORD_COLOR = ColorManager.getInstance().getColor(ColorManager.KEYWORD);
    private static final Color COMMENT_COLOR = ColorManager.getInstance().getColor(ColorManager.SINGLE_LINE_COMMENT);
    private static final Color STRING_COLOR = ColorManager.getInstance().getColor(ColorManager.STRING);
    private static final String[] DROOLS_KEYWORDS = Keywords.getInstance().getAllDroolsKeywords();
    private static final String[] JAVA_KEYWORDS = Keywords.getInstance().getAllJavaKeywords();
    private static final String[] MVEL_KEYWORDS = Keywords.getInstance().getAllMvelKeywords();
    private static final String[] JAVA_TYPES = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static final String[] JAVA_CONSTANTS = new String[]{"false", "true", "null"};
    private static final String[] MVEL_CONSTANTS = new String[]{"false", "true", "null", "nil", "empty", "this"};

    public DRLScanner() {
        Token token = new Token((Object)new TextAttribute(KEYWORD_COLOR, null, 1));
        Token token2 = new Token((Object)new TextAttribute(COMMENT_COLOR));
        Token token3 = new Token((Object)new TextAttribute(STRING_COLOR));
        Token token4 = new Token(null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new EndOfLineRule("//", (IToken)token2));
        arrayList.add(new EndOfLineRule("#", (IToken)token2));
        arrayList.add(new SingleLineRule("\"", "\"", (IToken)token3, '\\'));
        arrayList.add(new SingleLineRule("'", "'", (IToken)token3, '\\'));
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new RuleWordDetector(), (IToken)token4);
        int n = 0;
        while (n < DROOLS_KEYWORDS.length) {
            wordRule.addWord(DROOLS_KEYWORDS[n], (IToken)token);
            ++n;
        }
        n = 0;
        while (n < JAVA_KEYWORDS.length) {
            wordRule.addWord(JAVA_KEYWORDS[n], (IToken)token);
            ++n;
        }
        n = 0;
        while (n < JAVA_TYPES.length) {
            wordRule.addWord(JAVA_TYPES[n], (IToken)token);
            ++n;
        }
        n = 0;
        while (n < JAVA_CONSTANTS.length) {
            wordRule.addWord(JAVA_CONSTANTS[n], (IToken)token);
            ++n;
        }
        n = 0;
        while (n < MVEL_KEYWORDS.length) {
            wordRule.addWord(MVEL_KEYWORDS[n], (IToken)token);
            ++n;
        }
        n = 0;
        while (n < MVEL_CONSTANTS.length) {
            wordRule.addWord(MVEL_CONSTANTS[n], (IToken)token);
            ++n;
        }
        arrayList.add(wordRule);
        IRule[] iRuleArray = new IRule[arrayList.size()];
        arrayList.toArray(iRuleArray);
        this.setRules(iRuleArray);
    }
}

