/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.editor.GenericContextMenuProvider;
import org.drools.eclipse.flow.common.editor.OverviewOutlinePage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class GenericModelEditor
extends GraphicalEditorWithPalette {
    private Object model;
    private boolean savePreviouslyNeeded = false;
    private KeyHandler sharedKeyHandler;
    private PaletteRoot root;
    private OverviewOutlinePage overviewOutlinePage;

    public GenericModelEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void setModel(Object object) {
        this.model = object;
    }

    public Object getModel() {
        return this.model;
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry actionRegistry = this.getActionRegistry();
        DirectEditAction directEditAction = new DirectEditAction((IWorkbenchPart)this);
        actionRegistry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
        directEditAction = new AlignmentAction((IWorkbenchPart)this, 1);
        actionRegistry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
        directEditAction = new AlignmentAction((IWorkbenchPart)this, 2);
        actionRegistry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
        directEditAction = new AlignmentAction((IWorkbenchPart)this, 4);
        actionRegistry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
        directEditAction = new AlignmentAction((IWorkbenchPart)this, 8);
        actionRegistry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
        directEditAction = new AlignmentAction((IWorkbenchPart)this, 16);
        actionRegistry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
        directEditAction = new AlignmentAction((IWorkbenchPart)this, 32);
        actionRegistry.registerAction((IAction)directEditAction);
        this.getSelectionActions().add(directEditAction.getId());
    }

    public void commandStackChanged(EventObject eventObject) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(eventObject);
    }

    protected abstract void writeModel(OutputStream var1) throws IOException;

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        this.getGraphicalViewer().setEditPartFactory(this.createEditPartFactory());
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        ToggleGridAction toggleGridAction = new ToggleGridAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)toggleGridAction);
        GenericContextMenuProvider genericContextMenuProvider = new GenericContextMenuProvider(this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)genericContextMenuProvider);
        this.getSite().registerContextMenu("org.drools.eclipse.flow.editor.contextmenu", (MenuManager)genericContextMenuProvider, (ISelectionProvider)this.getGraphicalViewer());
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents(this.model);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeModel(byteArrayOutputStream);
            IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            iFile.setContents((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, false, iProgressMonitor);
            byteArrayOutputStream.close();
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        saveAsDialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        saveAsDialog.open();
        IPath iPath = saveAsDialog.getResult();
        if (iPath == null) {
            return;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IFile iFile = iWorkspace.getRoot().getFile(iPath);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    GenericModelEditor.this.writeModel(byteArrayOutputStream);
                    iFile.create((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, iProgressMonitor);
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
            this.setInput((IEditorInput)new FileEditorInput(iFile));
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    private void setSavePreviouslyNeeded(boolean bl) {
        this.savePreviouslyNeeded = bl;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = this.createPalette();
        }
        return this.root;
    }

    protected abstract PaletteRoot createPalette();

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = this.getFile();
            if (iFile != null) {
                this.setPartName(iFile.getName());
            }
            try {
                InputStream inputStream = iFile.getContents(false);
                this.createModel(inputStream);
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        } else if (iEditorInput instanceof IStorageEditorInput) {
            try {
                IStorage iStorage = ((IStorageEditorInput)iEditorInput).getStorage();
                this.setPartName(iStorage.getName());
                InputStream inputStream = iStorage.getContents();
                this.createModel(inputStream);
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        }
        if (this.getGraphicalViewer() != null) {
            this.initializeGraphicalViewer();
        }
    }

    public IFile getFile() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (!(iEditorInput instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    public IProject getProject() {
        IFile iFile = this.getFile();
        if (iFile != null) {
            return iFile.getProject();
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        IProject iProject = this.getProject();
        if (iProject != null) {
            try {
                IJavaProject iJavaProject;
                if (iProject.getNature("org.eclipse.jdt.core.javanature") != null && (iJavaProject = JavaCore.create((IProject)iProject)).exists()) {
                    return iJavaProject;
                }
            }
            catch (CoreException coreException) {
                DroolsEclipsePlugin.log(coreException);
            }
        }
        return null;
    }

    protected abstract void createModel(InputStream var1);

    public Object getAdapter(Class clazz) {
        if (clazz == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        if (clazz == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(clazz);
    }

    protected OverviewOutlinePage getOverviewOutlinePage() {
        if (this.overviewOutlinePage == null && this.getGraphicalViewer() != null) {
            ScalableRootEditPart scalableRootEditPart = (ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart();
            this.overviewOutlinePage = new OverviewOutlinePage(scalableRootEditPart);
        }
        return this.overviewOutlinePage;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void createImage(OutputStream outputStream, int n) {
        SWTGraphics sWTGraphics = null;
        GC gC = null;
        Image image = null;
        LayerManager layerManager = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure iFigure = layerManager.getLayer((Object)"Printable Layers");
        Rectangle rectangle = iFigure.getBounds();
        try {
            try {
                image = new Image((Device)Display.getDefault(), rectangle.width, rectangle.height);
                gC = new GC((Drawable)image);
                sWTGraphics = new SWTGraphics(gC);
                sWTGraphics.translate(rectangle.x * -1, rectangle.y * -1);
                iFigure.paint((Graphics)sWTGraphics);
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(outputStream, n);
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
                if (sWTGraphics != null) {
                    sWTGraphics.dispose();
                }
                if (gC != null) {
                    gC.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        }
        finally {
            if (sWTGraphics != null) {
                sWTGraphics.dispose();
            }
            if (gC != null) {
                gC.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

