/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementContainer;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.ruleflow.view.property.color.ColorPropertyDescriptor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultElementWrapper
implements ElementWrapper,
IPropertySource,
Serializable {
    private static final long serialVersionUID = 4L;
    private static boolean allowNodeCustomization = DroolsEclipsePlugin.getDefault().getPreferenceStore().getBoolean("Drools.Flow.AllowNodeCustomization");
    protected static IPropertyDescriptor[] DESCRIPTORS = allowNodeCustomization ? new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"Name", "\u540d\u524d"), new TextPropertyDescriptor("Id", "ID"){

        public CellEditor createPropertyEditor(Composite composite) {
            return null;
        }
    }, new ColorPropertyDescriptor("Color", "\u8272")} : new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"Name", "\u540d\u524d"), new TextPropertyDescriptor("Id", "ID"){

        public CellEditor createPropertyEditor(Composite composite) {
            return null;
        }
    }};
    public static final String NAME = "Name";
    public static final String ID = "Id";
    public static final String COLOR = "Color";
    private Object element;
    private ElementContainer parent;
    private transient Rectangle constraint;
    private List<ElementConnection> incomingConnections = new ArrayList<ElementConnection>();
    private List<ElementConnection> outgoingConnections = new ArrayList<ElementConnection>();
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();
    protected Color color;

    protected void setElement(Object object) {
        this.element = object;
    }

    public Object getElement() {
        return this.element;
    }

    @Override
    public void setConstraint(Rectangle rectangle) {
        this.constraint = rectangle;
        this.internalSetConstraint(rectangle);
        this.notifyListeners(3);
    }

    protected abstract void internalSetConstraint(Rectangle var1);

    @Override
    public Rectangle getConstraint() {
        if (this.constraint == null) {
            this.constraint = this.internalGetConstraint();
        }
        return this.constraint;
    }

    protected abstract Rectangle internalGetConstraint();

    @Override
    public void setParent(ElementContainer elementContainer) {
        this.parent = elementContainer;
    }

    @Override
    public ElementContainer getParent() {
        return this.parent;
    }

    @Override
    public List<ElementConnection> getOutgoingConnections() {
        return Collections.unmodifiableList(this.outgoingConnections);
    }

    @Override
    public List<ElementConnection> getIncomingConnections() {
        return Collections.unmodifiableList(this.incomingConnections);
    }

    @Override
    public void addIncomingConnection(ElementConnection elementConnection) {
        this.localAddIncomingConnection(elementConnection);
        this.internalAddIncomingConnection(elementConnection);
        this.notifyListeners(1);
    }

    @Override
    public void localAddIncomingConnection(ElementConnection elementConnection) {
        this.incomingConnections.add(elementConnection);
    }

    protected void internalAddIncomingConnection(ElementConnection elementConnection) {
    }

    @Override
    public void removeIncomingConnection(ElementConnection elementConnection) {
        this.incomingConnections.remove(elementConnection);
        this.internalRemoveIncomingConnection(elementConnection);
        this.notifyListeners(1);
    }

    protected void internalRemoveIncomingConnection(ElementConnection elementConnection) {
    }

    @Override
    public void addOutgoingConnection(ElementConnection elementConnection) {
        this.localAddOutgoingConnection(elementConnection);
        this.internalAddOutgoingConnection(elementConnection);
        this.notifyListeners(2);
    }

    @Override
    public void localAddOutgoingConnection(ElementConnection elementConnection) {
        this.outgoingConnections.add(elementConnection);
    }

    protected void internalAddOutgoingConnection(ElementConnection elementConnection) {
    }

    @Override
    public void removeOutgoingConnection(ElementConnection elementConnection) {
        this.outgoingConnections.remove(elementConnection);
        this.internalRemoveOutgoingConnection(elementConnection);
        this.notifyListeners(2);
    }

    protected void internalRemoveOutgoingConnection(ElementConnection elementConnection) {
    }

    @Override
    public void setName(String string) {
        this.internalSetName(string);
        this.notifyListeners(4);
    }

    protected void internalSetName(String string) {
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = this.internalGetColor();
        }
        return this.color;
    }

    protected Color internalGetColor() {
        return null;
    }

    public void setColor(Color color) {
        this.color = color;
        this.internalSetColor(color == null ? null : DefaultElementWrapper.RGBToInteger(color.getRGB()));
        this.notifyListeners(4);
    }

    protected void internalSetColor(Integer n) {
    }

    @Override
    public void addListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    @Override
    public void removeListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    protected void notifyListeners(int n) {
        ModelEvent modelEvent = new ModelEvent(n);
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged(modelEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.listeners = new ArrayList<ModelListener>();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object object) {
        return true;
    }

    public Object getPropertyValue(Object object) {
        if (NAME.equals(object)) {
            return this.getName();
        }
        if (ID.equals(object)) {
            return this.getId();
        }
        if (COLOR.equals(object)) {
            return this.getColor();
        }
        return null;
    }

    public void resetPropertyValue(Object object) {
        if (NAME.equals(object)) {
            this.setName("");
        }
        if (COLOR.equals(object)) {
            this.setColor(null);
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        if (NAME.equals(object)) {
            this.setName((String)object2);
        }
        if (COLOR.equals(object)) {
            this.setColor((Color)object2);
        }
    }

    public static Integer RGBToInteger(RGB rGB) {
        return new Integer(rGB.blue << 16 | rGB.green << 8 | rGB.red);
    }

    public static RGB integerToRGB(Integer n) {
        int n2 = n;
        return new RGB(n2 & 0xFF, (n2 & 0xFF00) >> 8, (n2 & 0xFF0000) >> 16);
    }
}

