/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.eclipse.draw2d.geometry.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementConnection
implements Serializable {
    private static final long serialVersionUID = 400L;
    public static final int CHANGE_BENDPOINTS = 1;
    public static final int CHANGE_LABEL = 2;
    private ElementWrapper source;
    private ElementWrapper target;
    private transient List<Point> bendpoints = new ArrayList<Point>();
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();

    public void localSetSource(ElementWrapper elementWrapper) {
        this.source = elementWrapper;
    }

    public void localSetTarget(ElementWrapper elementWrapper) {
        this.target = elementWrapper;
    }

    public void disconnect() {
        if (this.source == null) {
            throw new IllegalStateException("Can't disconnect, source is null");
        }
        if (this.target == null) {
            throw new IllegalStateException("Can't disconnect, target is null");
        }
        this.source.removeOutgoingConnection(this);
        this.target.removeIncomingConnection(this);
        this.source = null;
        this.target = null;
    }

    public void connect(ElementWrapper elementWrapper, ElementWrapper elementWrapper2) {
        if (elementWrapper == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (this.source != null) {
            throw new IllegalStateException("The source of a connection cannot be changed");
        }
        if (elementWrapper2 == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (this.target != null) {
            throw new IllegalStateException("The target of a connection cannot be changed");
        }
        this.source = elementWrapper;
        this.target = elementWrapper2;
        elementWrapper.addOutgoingConnection(this);
        elementWrapper2.addIncomingConnection(this);
    }

    public ElementWrapper getSource() {
        return this.source;
    }

    public ElementWrapper getTarget() {
        return this.target;
    }

    public void addBendpoint(int n, Point point) {
        this.bendpoints.add(n, point);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    public void removeBendpoint(int n) {
        this.bendpoints.remove(n);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    public void replaceBendpoint(int n, Point point) {
        this.bendpoints.set(n, point);
        this.internalSetBendpoints(this.bendpoints);
        this.notifyListeners(1);
    }

    protected void internalSetBendpoints(List<Point> list) {
    }

    public void localSetBendpoints(List<Point> list) {
        this.bendpoints = list;
    }

    public List<Point> getBendpoints() {
        if (this.bendpoints == null) {
            this.bendpoints = this.internalGetBendpoints();
        }
        return this.bendpoints;
    }

    protected abstract List<Point> internalGetBendpoints();

    public void addListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void notifyListeners(int n) {
        ModelEvent modelEvent = new ModelEvent(n);
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged(modelEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.listeners = new ArrayList<ModelListener>();
    }
}

