/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class ElementConnectionCreateCommand
extends Command {
    private ElementConnection connection;
    private ElementWrapper source;
    private ElementWrapper target;

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        List<ElementConnection> list = this.source.getOutgoingConnections();
        for (ElementConnection elementConnection : list) {
            if (!elementConnection.getTarget().equals(this.target)) continue;
            return false;
        }
        return this.source.acceptsOutgoingConnection(this.connection, this.target) && this.target != null && this.target.acceptsIncomingConnection(this.connection, this.source);
    }

    public void execute() {
        this.connection.connect(this.source, this.target);
    }

    public ElementWrapper getSource() {
        return this.source;
    }

    public ElementWrapper getTarget() {
        return this.target;
    }

    public void redo() {
        this.connection.connect(this.source, this.target);
    }

    public void setSource(ElementWrapper elementWrapper) {
        this.source = elementWrapper;
    }

    public void setConnection(ElementConnection elementConnection) {
        this.connection = elementConnection;
    }

    public void setTarget(ElementWrapper elementWrapper) {
        this.target = elementWrapper;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

