/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class ReconnectElementConnectionSourceCommand
extends Command {
    private ElementConnection connection;
    private ElementWrapper target;
    private ElementWrapper oldSource;
    private ElementWrapper newSource;

    public boolean canExecute() {
        if (this.connection.getTarget().equals(this.newSource)) {
            return false;
        }
        List<ElementConnection> list = this.newSource.getOutgoingConnections();
        int n = 0;
        while (n < list.size()) {
            ElementConnection elementConnection = list.get(n);
            if (elementConnection.getTarget().equals(this.target) && !elementConnection.getSource().equals(this.oldSource)) {
                return false;
            }
            ++n;
        }
        return this.newSource.acceptsOutgoingConnection(this.connection, this.target);
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.disconnect();
            this.connection.connect(this.newSource, this.target);
        }
    }

    public void setSource(ElementWrapper elementWrapper) {
        this.newSource = elementWrapper;
    }

    public void setConnection(ElementConnection elementConnection) {
        this.connection = elementConnection;
        this.target = elementConnection.getTarget();
        this.oldSource = elementConnection.getSource();
    }

    public void undo() {
        this.connection.disconnect();
        this.connection.connect(this.oldSource, this.target);
    }

    public void redo() {
        this.connection.disconnect();
        this.connection.connect(this.newSource, this.target);
    }
}

