/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class ReconnectElementConnectionTargetCommand
extends Command {
    private ElementConnection connection;
    private ElementWrapper oldTarget;
    private ElementWrapper newTarget;
    private ElementWrapper source;

    public boolean canExecute() {
        if (this.connection.getSource().equals(this.newTarget)) {
            return false;
        }
        List<ElementConnection> list = this.newTarget.getIncomingConnections();
        for (ElementConnection elementConnection : list) {
            if (!elementConnection.getSource().equals(this.source) || elementConnection.getTarget().equals(this.oldTarget)) continue;
            return false;
        }
        return this.newTarget.acceptsIncomingConnection(this.connection, this.source);
    }

    public void execute() {
        if (this.newTarget != null) {
            this.connection.disconnect();
            this.connection.connect(this.source, this.newTarget);
        }
    }

    public void setTarget(ElementWrapper elementWrapper) {
        this.newTarget = elementWrapper;
    }

    public void setConnection(ElementConnection elementConnection) {
        this.connection = elementConnection;
        this.source = elementConnection.getSource();
        this.oldTarget = elementConnection.getTarget();
    }

    public void undo() {
        this.connection.disconnect();
        this.connection.connect(this.source, this.oldTarget);
    }

    public void redo() {
        this.connection.disconnect();
        this.connection.connect(this.source, this.newTarget);
    }
}

