/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart;

import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.ElementFigure;
import org.drools.eclipse.flow.common.editor.policy.ElementContainerLayoutEditPolicy;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class ProcessEditPart
extends AbstractGraphicalEditPart
implements ModelListener {
    protected IFigure createFigure() {
        Figure figure = new Figure();
        figure.setLayoutManager((LayoutManager)new XYLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ElementContainerLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
    }

    protected List getModelChildren() {
        return this.getProcessWrapper().getElements();
    }

    public ProcessWrapper getProcessWrapper() {
        return (ProcessWrapper)this.getModel();
    }

    public void activate() {
        super.activate();
        ((ProcessWrapper)this.getModel()).addListener(this);
    }

    public void deactivate() {
        ((ProcessWrapper)this.getModel()).removeListener(this);
        super.deactivate();
    }

    public void modelChanged(ModelEvent modelEvent) {
        if (modelEvent.getChange() == 1) {
            this.refreshChildren();
        } else if (modelEvent.getChange() == 2) {
            this.refreshVisuals();
        }
    }

    public Object getAdapter(Class clazz) {
        Boolean bl;
        if (clazz == SnapToHelper.class && (bl = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && bl.booleanValue()) {
            return new SnapToGrid((GraphicalEditPart)this);
        }
        return super.getAdapter(clazz);
    }

    protected void refreshVisuals() {
        Animation.markBegin();
        ConnectionLayer connectionLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if ((this.getViewer().getControl().getStyle() & 0x8000000) == 0) {
            connectionLayer.setAntialias(1);
        }
        if (this.getProcessWrapper().getRouterLayout().equals(ProcessWrapper.ROUTER_LAYOUT_MANUAL)) {
            FanRouter fanRouter = new FanRouter();
            fanRouter.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
            connectionLayer.setConnectionRouter((ConnectionRouter)fanRouter);
        } else if (this.getProcessWrapper().getRouterLayout().equals(ProcessWrapper.ROUTER_LAYOUT_MANHATTAN)) {
            connectionLayer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        } else {
            connectionLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter(this.getFigure()));
        }
        Animation.run((int)400);
    }

    public boolean setTableModelBounds() {
        List list = this.getChildren();
        for (ElementEditPart elementEditPart : list) {
            ElementFigure elementFigure = (ElementFigure)elementEditPart.getFigure();
            if (elementFigure == null) continue;
            Rectangle rectangle = elementFigure.getBounds().getCopy();
            ElementWrapper elementWrapper = elementEditPart.getElementWrapper();
            elementWrapper.setConstraint(rectangle);
        }
        return true;
    }
}

