/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart.work;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.process.core.Work;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkEditor;
import org.drools.process.core.impl.WorkImpl;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EmailCustomEditor
extends EditBeanDialog
implements WorkEditor {
    private List<Recipient> recipients = new ArrayList<Recipient>();
    private Text fromText;
    private Text subjectText;
    private Text bodyText;

    public EmailCustomEditor(Shell shell) {
        super(shell, "\u500b\u5225\u30ef\u30fc\u30af\u30a8\u30c7\u30a3\u30bf");
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite composite) {
        Object object;
        Work work = (Work)this.getValue();
        String string = (String)work.getParameter("\u5dee\u51fa\u4eba");
        String string2 = (String)work.getParameter("\u5b9b\u5148");
        String string3 = (String)work.getParameter("\u672c\u6587");
        String string4 = (String)work.getParameter("\u984c\u540d");
        if (string2 != null) {
            String[] stringArray = string2.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                if (!"".equals(object)) {
                    Recipient recipient = new Recipient();
                    recipient.setEmail((String)object);
                    this.recipients.add(recipient);
                }
                ++n2;
            }
        }
        object = (Composite)super.createDialogArea(composite);
        object.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(object, 0);
        this.createHeadersTab(tabFolder);
        this.createBodyTab(tabFolder);
        if (string != null) {
            this.fromText.setText(string);
        }
        if (string4 != null) {
            this.subjectText.setText(string4);
        }
        if (string3 != null) {
            this.bodyText.setText(string3);
        }
        return object;
    }

    public void createHeadersTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("\u30d8\u30c3\u30c0\u30fc");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)gridLayout);
        tabItem.setControl((Control)composite);
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText("\u53d7\u53d6\u4eba");
        new Label(composite, 0);
        final TableViewer tableViewer = new TableViewer(composite, 67584);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new EmailLabelProvider());
        tableViewerColumn.setEditingSupport((EditingSupport)new EmailEditing(tableViewer));
        tableViewerColumn.getColumn().setText("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        tableViewerColumn.getColumn().setWidth(200);
        tableViewerColumn.getColumn().setMoveable(true);
        final Table table = tableViewer.getTable();
        GridData gridData2 = new GridData(4, 0x1000000, true, false, 2, 1);
        gridData2.heightHint = 128;
        table.setLayoutData((Object)gridData2);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)new RecipientsContentProvider());
        tableViewer.setInput(this.recipients);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        composite2.setLayout((Layout)new RowLayout());
        Button button = new Button(composite2, 0);
        button.setText("\u8ffd\u52a0");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Recipient recipient = new Recipient();
                EmailCustomEditor.this.recipients.add(recipient);
                tableViewer.add((Object)recipient);
                tableViewer.refresh();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Recipient recipient = new Recipient();
                EmailCustomEditor.this.recipients.add(recipient);
                tableViewer.add((Object)recipient);
                tableViewer.refresh();
            }
        });
        Button button2 = new Button(composite2, 0);
        button2.setText("\u524a\u9664");
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = table.getSelection();
                if (tableItemArray != null && tableItemArray.length > 0) {
                    EmailCustomEditor.this.recipients.remove((Recipient)tableItemArray[0].getData());
                    tableViewer.remove((Object)tableItemArray[0]);
                    tableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = table.getSelection();
                if (tableItemArray != null && tableItemArray.length > 0) {
                    EmailCustomEditor.this.recipients.remove((Recipient)tableItemArray[0].getData());
                    tableViewer.remove((Object)tableItemArray[0]);
                    tableViewer.refresh();
                }
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData());
        label2.setText("\u5dee\u51fa\u4eba");
        this.fromText = new Text(composite, 2048);
        this.fromText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void createBodyTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("\u672c\u6587");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2;
        composite.setLayout((Layout)gridLayout);
        tabItem.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("\u984c\u540d");
        this.subjectText = new Text(composite, 2048);
        this.subjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label2 = new Label(composite, 0);
        label2.setText("\u672c\u6587");
        this.bodyText = new Text(composite, 2050);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 175;
        this.bodyText.setLayoutData((Object)gridData);
    }

    protected Object updateValue(Object object) {
        WorkImpl workImpl = new WorkImpl();
        workImpl.setName(((Work)object).getName());
        workImpl.setParameter("\u5dee\u51fa\u4eba", (Object)this.fromText.getText());
        String string = "";
        int n = 0;
        while (n < this.recipients.size()) {
            string = String.valueOf(string) + this.recipients.get(n).getEmail();
            if (n != this.recipients.size() - 1) {
                string = String.valueOf(string) + ";";
            }
            ++n;
        }
        workImpl.setParameter("\u5b9b\u5148", (Object)string);
        workImpl.setParameter("\u984c\u540d", (Object)this.subjectText.getText());
        workImpl.setParameter("\u672c\u6587", (Object)this.bodyText.getText());
        workImpl.setParameterDefinitions(((Work)object).getParameterDefinitions());
        return workImpl;
    }

    public Work getWork() {
        return (Work)this.getValue();
    }

    public void setWork(Work work) {
        this.setValue(work);
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        if (!"Email".equals(workDefinition.getName())) {
            DroolsEclipsePlugin.log(new IllegalArgumentException("emailCustomEditor\u306f\u30e1\u30fc\u30eb\u4f5c\u696d\u9805\u76ee\u3057\u304b\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002"));
        }
    }

    public boolean show() {
        int n = this.open();
        return n == 0;
    }

    private class DisplayNameEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public DisplayNameEditing(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.cellEditor;
        }

        protected Object getValue(Object object) {
            return ((Recipient)object).getDisplayName();
        }

        protected void setValue(Object object, Object object2) {
            ((Recipient)object).setDisplayName(object2.toString());
            this.getViewer().update(object, null);
        }
    }

    private class DisplayNameLabelProvider
    extends ColumnLabelProvider {
        private DisplayNameLabelProvider() {
        }

        public String getText(Object object) {
            return ((Recipient)object).getDisplayName();
        }
    }

    private class EmailEditing
    extends EditingSupport {
        private TextCellEditor cellEditor;

        public EmailEditing(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.cellEditor;
        }

        protected Object getValue(Object object) {
            return ((Recipient)object).getEmail();
        }

        protected void setValue(Object object, Object object2) {
            ((Recipient)object).setEmail(object2.toString());
            this.getViewer().update(object, null);
        }
    }

    private class EmailLabelProvider
    extends ColumnLabelProvider {
        private EmailLabelProvider() {
        }

        public String getText(Object object) {
            return ((Recipient)object).getEmail();
        }
    }

    private class Recipient {
        private String type = "to";
        private String displayName = "";
        private String email = "john.doe@mail.com";

        private Recipient() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String string) {
            this.displayName = string;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String string) {
            this.email = string;
        }
    }

    private class RecipientsContentProvider
    implements IStructuredContentProvider {
        private RecipientsContentProvider() {
        }

        public Object[] getElements(Object object) {
            return EmailCustomEditor.this.recipients.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class TypeEditing
    extends EditingSupport {
        private ComboBoxCellEditor cellEditor;
        private String[] values;

        public TypeEditing(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.values = new String[]{"to", "cc", "bcc"};
            this.cellEditor = new ComboBoxCellEditor((Composite)tableViewer.getTable(), this.values);
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.cellEditor;
        }

        protected Object getValue(Object object) {
            Recipient recipient = (Recipient)object;
            return new Integer(Arrays.binarySearch(this.values, recipient.getType()));
        }

        protected void setValue(Object object, Object object2) {
            int n = (Integer)object2;
            if (n != -1) {
                ((Recipient)object).setType(this.values[n]);
            }
            this.getViewer().update(object, null);
        }
    }

    private class TypeLabelProvider
    extends ColumnLabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object object) {
            return ((Recipient)object).getType();
        }
    }
}

