/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.datatype.DataTypeRegistry;
import org.drools.eclipse.flow.common.view.datatype.editor.DataTypeEditor;
import org.drools.eclipse.flow.common.view.datatype.editor.impl.EmptyEditor;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.UndefinedDataType;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DataTypeEditorComposite
extends Composite
implements DataTypeEditor.DataTypeListener {
    private DataTypeRegistry registry;
    private DataTypeEditor dataTypeEditor;
    private List listeners = new ArrayList();

    public DataTypeEditorComposite(Composite composite, int n, DataTypeRegistry dataTypeRegistry) {
        super(composite, n);
        this.registry = dataTypeRegistry;
        this.setLayout((Layout)new FillLayout());
        this.dataTypeEditor = new EmptyEditor(this);
    }

    public void setDataType(DataType dataType) {
        if (dataType == null) {
            this.reset();
        } else {
            this.dataTypeEditor.removeListener(this);
            ((Composite)this.dataTypeEditor).dispose();
            this.dataTypeEditor = null;
            Class clazz = null;
            try {
                clazz = this.registry.getDataTypeInfo(dataType.getClass()).getDataTypeEditorClass();
                this.dataTypeEditor = (DataTypeEditor)clazz.getConstructor(Composite.class).newInstance(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DroolsEclipsePlugin.log(illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                DroolsEclipsePlugin.log(instantiationException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DroolsEclipsePlugin.log(noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                DroolsEclipsePlugin.log(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                DroolsEclipsePlugin.log(illegalAccessException);
            }
            if (this.dataTypeEditor == null) {
                this.dataTypeEditor = new EmptyEditor(this);
            }
            this.dataTypeEditor.addListener(this);
            this.dataTypeEditor.setDataType(dataType);
            ((Composite)this.dataTypeEditor).setBackground(this.getBackground());
            this.layout();
        }
    }

    public DataType getDataType() {
        return this.dataTypeEditor.getDataType();
    }

    public void reset() {
        this.setDataType((DataType)UndefinedDataType.getInstance());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ((Composite)this.dataTypeEditor).setEnabled(bl);
    }

    public void addListener(DataTypeEditor.DataTypeListener dataTypeListener) {
        this.listeners.add(dataTypeListener);
    }

    public void removeListener(DataTypeEditor.DataTypeListener dataTypeListener) {
        this.listeners.remove(dataTypeListener);
    }

    private void notifyListeners() {
        DataType dataType = this.getDataType();
        for (DataTypeEditor.DataTypeListener dataTypeListener : this.listeners) {
            dataTypeListener.dataTypeChanged(dataType);
        }
    }

    public void dataTypeChanged(DataType dataType) {
        this.notifyListeners();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        ((Composite)this.dataTypeEditor).setBackground(color);
    }
}

