/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.property;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.common.view.property.MapItemDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditMapDialog<S, T>
extends EditBeanDialog<Map<S, T>> {
    private Class<? extends EditBeanDialog<T>> editItemDialogClass;
    private Map<S, T> newMap;
    private ListViewer listViewer;
    private Button removeButton;
    private Button editButton;

    protected EditMapDialog(Shell shell, String string, Class<? extends EditBeanDialog<T>> clazz) {
        super(shell, string);
        this.editItemDialogClass = clazz;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.listViewer = new ListViewer(composite2, 4);
        this.listViewer.add(this.newMap.keySet().toArray());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EditMapDialog.this.removeButton.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
                EditMapDialog.this.editButton.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        this.listViewer.getList().setLayoutData((Object)gridData);
        Button button = new Button(composite2, 0);
        button.setText("\u8ffd\u52a0");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditMapDialog.this.addItem();
            }
        });
        this.removeButton = new Button(composite2, 0);
        this.removeButton.setText("\u524a\u9664");
        this.removeButton.setEnabled(false);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditMapDialog.this.removeItem();
            }
        });
        this.editButton = new Button(composite2, 0);
        this.editButton.setText("\u7de8\u96c6");
        this.editButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditMapDialog.this.editItem();
            }
        });
        return composite2;
    }

    @Override
    public void setValue(Map<S, T> map) {
        super.setValue(map);
        this.newMap = map == null ? new HashMap<S, T>() : new HashMap<S, T>(map);
    }

    @Override
    protected Map<S, T> updateValue(Map<S, T> map) {
        return this.newMap;
    }

    private void addItem() {
        T t;
        EditBeanDialog<T> editBeanDialog = this.createEditItemDialog();
        editBeanDialog.setValue(this.createItem());
        int n = editBeanDialog.open();
        Object s = ((MapItemDialog)((Object)editBeanDialog)).getKey();
        T t2 = editBeanDialog.getValue();
        if (n != 1 && (t = this.newMap.put(s, t2)) == null) {
            this.listViewer.add(s);
        }
    }

    protected abstract T createItem();

    private void editItem() {
        EditBeanDialog<T> editBeanDialog = this.createEditItemDialog();
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            ((MapItemDialog)((Object)editBeanDialog)).setKey(e);
            editBeanDialog.setValue(this.newMap.get(e));
            int n = editBeanDialog.open();
            T t = editBeanDialog.getValue();
            if (n != 1) {
                this.newMap.put(e, t);
            }
        }
    }

    private void removeItem() {
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            this.newMap.remove(e);
            this.listViewer.remove(e);
        }
    }

    protected EditBeanDialog<T> createEditItemDialog() {
        try {
            return this.editItemDialogClass.getConstructor(Shell.class).newInstance(this.getShell());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

