/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.definition.process.Node;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.NodeWrapper;
import org.drools.workflow.core.Connection;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.eclipse.draw2d.geometry.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionWrapper
extends ElementConnection {
    private static final long serialVersionUID = 400L;
    private ConnectionImpl connection;

    public Connection getConnection() {
        return this.connection;
    }

    public void localSetConnection(Connection connection) {
        this.connection = (ConnectionImpl)connection;
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.connection.terminate();
        this.connection = null;
    }

    @Override
    public void connect(ElementWrapper elementWrapper, ElementWrapper elementWrapper2) {
        this.connection = new ConnectionImpl((Node)((NodeWrapper)elementWrapper).getNode(), "DROOLS_DEFAULT", (Node)((NodeWrapper)elementWrapper2).getNode(), "DROOLS_DEFAULT");
        super.connect(elementWrapper, elementWrapper2);
    }

    @Override
    protected List<Point> internalGetBendpoints() {
        return this.stringToBendpoints((String)this.connection.getMetaData("bendpoints"));
    }

    @Override
    protected void internalSetBendpoints(List<Point> list) {
        this.connection.setMetaData("bendpoints", (Object)this.bendpointsToString(list));
    }

    private String bendpointsToString(List<Point> list) {
        if (list == null) {
            return null;
        }
        String string = "[";
        Iterator<Point> iterator = list.iterator();
        while (iterator.hasNext()) {
            Point point = iterator.next();
            string = String.valueOf(string) + point.x + "," + point.y + (iterator.hasNext() ? ";" : "");
        }
        string = String.valueOf(string) + "]";
        return string;
    }

    private List<Point> stringToBendpoints(String string) {
        String[] stringArray;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (string == null) {
            return arrayList;
        }
        string = string.substring(1, string.length() - 1);
        String[] stringArray2 = stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if ((string2 = string2.trim()).length() != 0) {
                String[] stringArray3 = string2.split(",");
                if (stringArray3.length != 2) {
                    throw new IllegalArgumentException("Unexpected bendpoint: " + string2 + " for bendpoints " + stringArray + " - nb points = " + stringArray3.length);
                }
                try {
                    arrayList.add(new Point(new Integer(stringArray3[0]).intValue(), new Integer(stringArray3[1]).intValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Could not parse bendpoint " + string2, numberFormatException);
                }
            }
            ++n2;
        }
        return arrayList;
    }
}

