/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.xml.XmlProcessReader;
import org.drools.compiler.xml.XmlRuleFlowProcessDumper;
import org.drools.compiler.xml.processes.RuleFlowMigrator;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.WorkItemDefinitions;
import org.drools.eclipse.flow.common.editor.GenericModelEditor;
import org.drools.eclipse.flow.ruleflow.core.RuleFlowProcessWrapper;
import org.drools.eclipse.flow.ruleflow.core.RuleFlowWrapperBuilder;
import org.drools.eclipse.flow.ruleflow.core.StartNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.WorkItemWrapper;
import org.drools.eclipse.flow.ruleflow.editor.RuleFlowPaletteFactory;
import org.drools.eclipse.flow.ruleflow.editor.editpart.RuleFlowEditPartFactory;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkDefinitionExtension;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class RuleFlowModelEditor
extends GenericModelEditor {
    protected EditPartFactory createEditPartFactory() {
        RuleFlowEditPartFactory ruleFlowEditPartFactory = new RuleFlowEditPartFactory();
        ruleFlowEditPartFactory.setProject(this.getJavaProject());
        return ruleFlowEditPartFactory;
    }

    protected PaletteRoot createPalette() {
        return RuleFlowPaletteFactory.createPalette();
    }

    protected Object createModel() {
        RuleFlowProcessWrapper ruleFlowProcessWrapper = new RuleFlowProcessWrapper();
        StartNodeWrapper startNodeWrapper = new StartNodeWrapper();
        startNodeWrapper.setConstraint(new Rectangle(100, 100, -1, -1));
        ruleFlowProcessWrapper.addElement(startNodeWrapper);
        startNodeWrapper.setParent(ruleFlowProcessWrapper);
        IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
        String string = iFile.getName();
        ruleFlowProcessWrapper.setName(string.substring(0, string.length() - 3));
        return ruleFlowProcessWrapper;
    }

    public RuleFlowProcessWrapper getRuleFlowModel() {
        return (RuleFlowProcessWrapper)this.getModel();
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            this.refreshPalette(((IFileEditorInput)iEditorInput).getFile());
        }
    }

    private void refreshPalette(IFile iFile) {
        if (this.getPaletteRoot().getChildren().size() <= 2) {
            return;
        }
        IJavaProject iJavaProject = this.getJavaProject();
        if (iJavaProject != null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader uRLClassLoader = ProjectClassLoader.getProjectClassLoader(iJavaProject);
                try {
                    Thread.currentThread().setContextClassLoader(uRLClassLoader);
                    PaletteDrawer paletteDrawer = (PaletteDrawer)this.getPaletteRoot().getChildren().get(2);
                    ArrayList<CombinedTemplateCreationEntry> arrayList = new ArrayList<CombinedTemplateCreationEntry>();
                    try {
                        for (final WorkDefinition workDefinition : WorkItemDefinitions.getWorkDefinitions((IResource)iFile).values()) {
                            String string;
                            Object object;
                            String string2 = workDefinition.getName();
                            String string3 = null;
                            if (workDefinition instanceof WorkDefinitionExtension) {
                                object = (WorkDefinitionExtension)workDefinition;
                                string = object.getDisplayName();
                                string2 = object.getExplanationText();
                                string3 = object.getIcon();
                            } else {
                                string = workDefinition.getName();
                            }
                            object = null;
                            if (string3 != null) {
                                object = uRLClassLoader.getResource(string3);
                            }
                            if (object == null) {
                                object = DroolsEclipsePlugin.getDefault().getBundle().getEntry("icons/action.gif");
                            }
                            CombinedTemplateCreationEntry combinedTemplateCreationEntry = new CombinedTemplateCreationEntry(string, string2, WorkItemWrapper.class, (CreationFactory)new SimpleFactory(WorkItemWrapper.class){

                                public Object getNewObject() {
                                    WorkItemWrapper workItemWrapper = (WorkItemWrapper)super.getNewObject();
                                    workItemWrapper.setName(string);
                                    workItemWrapper.setWorkDefinition(workDefinition);
                                    return workItemWrapper;
                                }
                            }, ImageDescriptor.createFromURL((URL)object), ImageDescriptor.createFromURL((URL)object));
                            arrayList.add(combinedTemplateCreationEntry);
                        }
                    }
                    catch (Throwable throwable) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Parsing work item definitions", (String)throwable.getMessage());
                    }
                    paletteDrawer.setChildren(arrayList);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
            catch (Exception exception) {
                DroolsEclipsePlugin.log(exception);
            }
        }
    }

    protected void writeModel(OutputStream outputStream) throws IOException {
        this.writeModel(outputStream, true);
    }

    protected void writeModel(OutputStream outputStream, boolean bl) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        try {
            XmlRuleFlowProcessDumper xmlRuleFlowProcessDumper = XmlRuleFlowProcessDumper.INSTANCE;
            String string = xmlRuleFlowProcessDumper.dump((WorkflowProcess)this.getRuleFlowModel().getRuleFlowProcess(), bl);
            outputStreamWriter.write(string);
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
        outputStreamWriter.close();
    }

    protected void createModel(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            PackageBuilderConfiguration packageBuilderConfiguration = new PackageBuilderConfiguration();
            XmlProcessReader xmlProcessReader = new XmlProcessReader(packageBuilderConfiguration.getSemanticModules());
            StringReader stringReader = null;
            try {
                RuleFlowProcess ruleFlowProcess;
                String string = RuleFlowMigrator.convertReaderToString((Reader)inputStreamReader);
                if (RuleFlowMigrator.needToMigrateRFM((String)string)) {
                    string = RuleFlowMigrator.portRFToCurrentVersion((String)string);
                    MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Incompatible RuleFlow Version", (String)"WARNING! The selected RuleFlow is Drools version 4 format.\n\nAny changes made to this RuleFlow will be saved in Drools 5 format, which is not compatible with Drools 4. To convert this RuleFlow to Drools 5 format, select Save As from the File menu and overwrite this file - the new RuleFlow file will be saved in Drools 5 format.");
                }
                if ((ruleFlowProcess = (RuleFlowProcess)xmlProcessReader.read((Reader)(stringReader = new StringReader(string)))) == null) {
                    this.setModel(this.createModel());
                } else {
                    this.setModel(new RuleFlowWrapperBuilder().getProcessWrapper((Process)ruleFlowProcess, this.getJavaProject()));
                }
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Could not read RuleFlow file", (String)("An exception occurred while reading in the RuleFlow XML: " + throwable.getMessage() + " See the error log for more details."));
                this.setModel(this.createModel());
            }
            if (stringReader != null) {
                ((Reader)stringReader).close();
            }
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
    }
}

