/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor.editpart;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.AbstractElementFigure;
import org.drools.eclipse.flow.ruleflow.core.WorkItemWrapper;
import org.drools.eclipse.flow.ruleflow.skin.SkinManager;
import org.drools.eclipse.flow.ruleflow.skin.SkinProvider;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.process.core.Work;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkDefinitionExtension;
import org.drools.process.core.WorkEditor;
import org.drools.workflow.core.node.WorkItemNode;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySource;

public class WorkItemEditPart
extends ElementEditPart {
    private String SKIN = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Flow.Skin");
    private static final Color color = new Color((Device)Display.getCurrent(), 255, 250, 205);

    protected IFigure createFigure() {
        IJavaProject iJavaProject;
        Image image;
        SkinProvider skinProvider = SkinManager.getInstance().getSkinProvider(this.SKIN);
        WorkItemFigureInterface workItemFigureInterface = skinProvider.createWorkItemFigure();
        Rectangle rectangle = this.getElementWrapper().getConstraint();
        if (rectangle.width == -1) {
            rectangle.width = workItemFigureInterface.getSize().width;
        }
        if (rectangle.height == -1) {
            rectangle.height = workItemFigureInterface.getSize().height;
        }
        this.getElementWrapper().setConstraint(rectangle);
        String string = null;
        WorkDefinition workDefinition = this.getWorkDefinition();
        if (workDefinition instanceof WorkDefinitionExtension) {
            string = ((WorkDefinitionExtension)workDefinition).getIcon();
        }
        if (string == null) {
            string = "icons/action.gif";
        }
        if ((image = DroolsPluginImages.getImage(string)) == null && (iJavaProject = this.getProject()) != null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader uRLClassLoader = ProjectClassLoader.getProjectClassLoader(iJavaProject);
                try {
                    Thread.currentThread().setContextClassLoader(uRLClassLoader);
                    image = ImageDescriptor.createFromURL((URL)uRLClassLoader.getResource(string)).createImage();
                    DroolsPluginImages.putImage(string, image);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
            catch (Exception exception) {
                DroolsEclipsePlugin.log(exception);
            }
        }
        workItemFigureInterface.setIcon(image);
        return workItemFigureInterface;
    }

    protected WorkItemWrapper getWorkItemWrapper() {
        return (WorkItemWrapper)this.getElementWrapper();
    }

    private WorkDefinition getWorkDefinition() {
        return this.getWorkItemWrapper().getWorkDefinition();
    }

    protected void doubleClicked() {
        Work work;
        String string;
        super.doubleClicked();
        WorkDefinition workDefinition = this.getWorkDefinition();
        if (workDefinition instanceof WorkDefinitionExtension && (string = ((WorkDefinitionExtension)workDefinition).getCustomEditor()) != null && (work = this.openEditor(string, workDefinition)) != null) {
            SetWorkCommand setWorkCommand = new SetWorkCommand();
            setWorkCommand.setPropertyValue(work);
            CommandStack commandStack = this.getViewer().getEditDomain().getCommandStack();
            commandStack.execute((Command)setWorkCommand);
        }
    }

    private Work openEditor(String string, WorkDefinition workDefinition) {
        IJavaProject iJavaProject = this.getProject();
        if (iJavaProject != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader uRLClassLoader = ProjectClassLoader.getProjectClassLoader(iJavaProject);
            try {
                Thread.currentThread().setContextClassLoader(uRLClassLoader);
                Class<?> clazz = uRLClassLoader.loadClass(string);
                Constructor<?> constructor = clazz.getConstructor(Shell.class);
                WorkEditor workEditor = (WorkEditor)constructor.newInstance(this.getViewer().getControl().getShell());
                workEditor.setWorkDefinition(workDefinition);
                WorkItemNode workItemNode = this.getWorkItemWrapper().getWorkItemNode();
                workEditor.setWork(workItemNode.getWork());
                boolean bl = workEditor.show();
                Work work = bl ? workEditor.getWork() : null;
                Thread.currentThread().setContextClassLoader(classLoader);
                return work;
            }
            catch (Throwable throwable) {
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    throw throwable;
                }
                catch (Exception exception) {
                    DroolsEclipsePlugin.log(exception);
                }
            }
        }
        return null;
    }

    private class SetWorkCommand
    extends Command {
        protected Work propertyValue;
        protected Work undoValue;
        protected IPropertySource target;

        public SetWorkCommand() {
            super("Set Work Value");
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            this.undoValue = WorkItemEditPart.this.getWorkItemWrapper().getWorkItemNode().getWork();
            WorkItemEditPart.this.getWorkItemWrapper().getWorkItemNode().setWork(this.propertyValue);
        }

        public void redo() {
            this.execute();
        }

        public void setPropertyValue(Work work) {
            this.propertyValue = work;
        }

        public void undo() {
            WorkItemEditPart.this.getWorkItemWrapper().getWorkItemNode().setWork(this.undoValue);
        }
    }

    public static class WorkItemFigure
    extends AbstractElementFigure
    implements WorkItemFigureInterface {
        private RoundedRectangle rectangle;
        private ConnectionAnchor defaultConnectionAnchor;
        private List<ConnectionAnchor> outgoingConnectionAnchors = new ArrayList<ConnectionAnchor>();

        public WorkItemFigure() {
            this.defaultConnectionAnchor = new ChopboxAnchor((IFigure)this);
        }

        public void layoutConnectionAnchors() {
        }

        public ConnectionAnchor getOutgoingConnectionAnchorAt(Point point) {
            ConnectionAnchor connectionAnchor = null;
            long l = Long.MAX_VALUE;
            for (ConnectionAnchor connectionAnchor2 : this.outgoingConnectionAnchors) {
                Point point2 = connectionAnchor2.getLocation(null);
                long l2 = point.getDistance2(point2);
                if (l2 >= l) continue;
                l = l2;
                connectionAnchor = connectionAnchor2;
            }
            if (l > 100L) {
                return this.defaultConnectionAnchor;
            }
            return connectionAnchor;
        }

        protected void customizeFigure() {
            this.rectangle = new RoundedRectangle();
            this.rectangle.setCornerDimensions(new Dimension(25, 25));
            this.add((IFigure)this.rectangle, 0);
            this.rectangle.setBackgroundColor(color);
            this.rectangle.setBounds(this.getBounds());
            this.setSelected(false);
        }

        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            this.rectangle.setBounds(rectangle);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            this.rectangle.setLineWidth(bl ? 3 : 1);
            this.repaint();
        }

        public void validate() {
            if (this.isValid()) {
                return;
            }
            this.layoutConnectionAnchors();
            super.validate();
        }
    }

    public static interface WorkItemFigureInterface
    extends IFigure {
        public void setIcon(Image var1);
    }
}

