/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.drools.lang.descr.GlobalDescr;
import org.drools.workflow.core.WorkflowProcess;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCompletionProcessor
extends RuleCompletionProcessor {
    private WorkflowProcess process;
    private List<String> imports;
    private List<String> functions;
    private List<GlobalDescr> globals;
    private Map<String, String> attributes;
    private String dialect;

    public ActionCompletionProcessor(WorkflowProcess workflowProcess) {
        super((AbstractRuleEditor)null);
        this.process = workflowProcess;
    }

    public void setDialect(String string) {
        this.dialect = string;
        this.attributes = null;
    }

    @Override
    public IEditorPart getEditor() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench != null && (iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow()) != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getActiveEditor();
        }
        return null;
    }

    @Override
    protected String readBackwards(int n, IDocument iDocument) throws BadLocationException {
        int n2 = iDocument.getPartition(n).getOffset();
        String string = iDocument.get(n2, n - n2);
        return "rule dummy " + (this.dialect == null ? "" : " dialect \"" + this.dialect + "\" ") + "\n when \n then \n org.drools.spi.ProcessContext context = null; \n org.drools.runtime.process.ProcessContext kcontext = null; \n " + string;
    }

    @Override
    public List<String> getImports() {
        if (this.imports == null) {
            this.loadImports();
        }
        return this.imports;
    }

    private void loadImports() {
        this.imports = new ArrayList<String>();
        List list = this.process.getImports();
        if (list != null) {
            for (String string : list) {
                if (string.endsWith(".*")) {
                    IJavaProject iJavaProject = this.getJavaProject();
                    if (iJavaProject == null) continue;
                    String string2 = string.substring(0, string.length() - 2);
                    this.imports.addAll(DRLRuleEditor.getAllClassesInPackage(string2, iJavaProject));
                    continue;
                }
                this.imports.add(string);
            }
        }
    }

    @Override
    public List<GlobalDescr> getGlobals() {
        if (this.globals == null) {
            this.loadGlobals();
        }
        return this.globals;
    }

    private void loadGlobals() {
        String[] stringArray = this.process.getGlobalNames();
        if (this.globals == null) {
            this.globals = new ArrayList<GlobalDescr>(stringArray.length);
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.globals.add(new GlobalDescr(string, "java.lang.Object"));
            ++n2;
        }
    }

    @Override
    protected List<String> getFunctions() {
        if (this.functions == null) {
            this.loadFunctions();
        }
        return this.functions;
    }

    private void loadFunctions() {
        this.functions = new ArrayList<String>();
        List list = this.process.getFunctionImports();
        if (list != null) {
            for (String string : list) {
                int n = string.lastIndexOf(46);
                if (n == -1) continue;
                this.functions.add(string.substring(n + 1));
            }
        }
    }

    private void loadAttributes() {
        this.attributes = new HashMap<String, String>();
        if (this.dialect != null) {
            this.attributes.put("dialect", this.dialect);
        }
    }

    @Override
    protected Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.loadAttributes();
        }
        return this.attributes;
    }

    private IJavaProject getJavaProject() {
        IEditorPart iEditorPart = this.getEditor();
        if (iEditorPart != null && iEditorPart.getEditorInput() instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorPart.getEditorInput()).getFile();
            try {
                if (iFile.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                    return JavaCore.create((IProject)iFile.getProject());
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void reset() {
        this.imports = null;
        this.globals = null;
    }
}

