/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.action;

import java.util.List;
import java.util.Map;
import org.drools.core.util.ArrayUtils;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.ruleflow.view.property.action.ActionCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionDialog
extends EditBeanDialog<DroolsAction> {
    private static final String[] DIALECTS = new String[]{"mvel", "java"};
    private WorkflowProcess process;
    private TabFolder tabFolder;
    private SourceViewer actionViewer;
    private Combo dialectCombo;
    private ActionCompletionProcessor completionProcessor;

    public ActionDialog(Shell shell, WorkflowProcess workflowProcess) {
        super(shell, "\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30c7\u30a3\u30bf");
        this.process = workflowProcess;
    }

    @Override
    protected DroolsAction updateValue(DroolsAction droolsAction) {
        if (this.tabFolder.getSelectionIndex() == 0) {
            DroolsConsequenceAction droolsConsequenceAction = new DroolsConsequenceAction();
            droolsConsequenceAction.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
            droolsConsequenceAction.setConsequence(this.actionViewer.getDocument().get());
            return droolsConsequenceAction;
        }
        return null;
    }

    @Override
    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite composite) {
        this.actionViewer = new SourceViewer(composite, null, 2048);
        this.actionViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer iSourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                ActionDialog.this.completionProcessor = new ActionCompletionProcessor(ActionDialog.this.process);
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)ActionDialog.this.completionProcessor, "__dftl_partition_content_type");
                contentAssistant.setProposalPopupOrientation(10);
                return contentAssistant;
            }
        });
        this.completionProcessor.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
        Object t = this.getValue();
        String string = null;
        if (t instanceof DroolsConsequenceAction) {
            string = ((DroolsConsequenceAction)t).getConsequence();
        }
        if (string == null) {
            string = "";
        }
        Document document = new Document(string);
        this.actionViewer.setDocument((IDocument)document);
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        fastPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)fastPartitioner);
        this.actionViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && keyEvent.stateMask == 262144) {
                    ActionDialog.this.actionViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        return this.actionViewer.getControl();
    }

    private Control createDialectCombo(Composite composite) {
        String string;
        int n;
        this.dialectCombo = new Combo(composite, 12);
        this.dialectCombo.setItems(DIALECTS);
        Object t = this.getValue();
        int n2 = 0;
        if (t instanceof DroolsConsequenceAction && (n = ArrayUtils.indexOf((Object[])DIALECTS, (Object)(string = ((DroolsConsequenceAction)t).getDialect()))) >= 0) {
            n2 = n;
        }
        this.dialectCombo.select(n2);
        this.dialectCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ActionDialog.this.completionProcessor.setDialect(ActionDialog.this.dialectCombo.getItem(ActionDialog.this.dialectCombo.getSelectionIndex()));
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActionDialog.this.completionProcessor.setDialect(ActionDialog.this.dialectCombo.getItem(ActionDialog.this.dialectCombo.getSelectionIndex()));
            }
        });
        return this.dialectCombo;
    }

    public Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("\u8a00\u8a9e\uff1a");
        this.createDialectCombo(composite2);
        Button button = new Button(composite2, 8);
        button.setText("\u30a4\u30f3\u30dd\u30fc\u30c8 ...");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActionDialog.this.importButtonPressed();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText("\u30b0\u30ed\u30fc\u30d0\u30eb ...");
        button2.setFont(JFaceResources.getDialogFont());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActionDialog.this.globalButtonPressed();
            }
        });
        this.tabFolder = new TabFolder(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("\u30a8\u30c7\u30a3\u30bf");
        tabItem.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    private void importButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowImportsDialog ruleFlowImportsDialog = new RuleFlowImportsDialog(ActionDialog.this.getShell(), ActionDialog.this.process);
                ruleFlowImportsDialog.create();
                int n = ruleFlowImportsDialog.open();
                if (n != 1) {
                    List<String> list = ruleFlowImportsDialog.getImports();
                    ActionDialog.this.process.setImports(list);
                    List<String> list2 = ruleFlowImportsDialog.getFunctionImports();
                    ActionDialog.this.process.setFunctionImports(list2);
                    ActionDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }

    private void globalButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowGlobalsDialog ruleFlowGlobalsDialog = new RuleFlowGlobalsDialog(ActionDialog.this.getShell(), ActionDialog.this.process);
                ruleFlowGlobalsDialog.create();
                int n = ruleFlowGlobalsDialog.open();
                if (n != 1) {
                    Map<String, String> map = ruleFlowGlobalsDialog.getGlobals();
                    ActionDialog.this.process.setGlobals(map);
                    ActionDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }
}

