/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.drools.lang.descr.GlobalDescr;
import org.drools.process.core.context.variable.Variable;
import org.drools.process.core.context.variable.VariableScope;
import org.drools.process.core.datatype.DataType;
import org.drools.workflow.core.WorkflowProcess;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintCompletionProcessor
extends RuleCompletionProcessor {
    private WorkflowProcess process;
    private List<String> imports;
    private List<GlobalDescr> globals;
    private String type;

    public ConstraintCompletionProcessor(WorkflowProcess workflowProcess) {
        super((AbstractRuleEditor)null);
        this.process = workflowProcess;
    }

    @Override
    public IEditorPart getEditor() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench != null && (iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow()) != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getActiveEditor();
        }
        return null;
    }

    public void setType(String string) {
        this.type = string;
    }

    @Override
    protected String readBackwards(int n, IDocument iDocument) throws BadLocationException {
        int n2 = iDocument.getPartition(n).getOffset();
        String string = iDocument.get(n2, n - n2);
        if ("code".equals(this.type)) {
            if (string.startsWith("return ")) {
                string = string.substring(7);
            }
            String string2 = "rule dummy when eval( ";
            VariableScope variableScope = (VariableScope)this.process.getDefaultContext("VariableScope");
            if (variableScope != null) {
                for (Variable variable : variableScope.getVariables()) {
                    DataType dataType = variable.getType();
                    string2 = String.valueOf(string2) + dataType.getStringType() + " " + variable.getName() + "; ";
                }
            }
            return String.valueOf(string2) + string;
        }
        return "rule dummy \n when \n" + string;
    }

    public List getImports() {
        if (this.imports == null) {
            this.loadImports();
        }
        return this.imports;
    }

    private void loadImports() {
        this.imports = new ArrayList<String>();
        List list = this.process.getImports();
        if (list != null) {
            for (String string : list) {
                if (string.endsWith(".*")) {
                    IJavaProject iJavaProject = this.getJavaProject();
                    if (iJavaProject == null) continue;
                    String string2 = string.substring(0, string.length() - 2);
                    this.imports.addAll(DRLRuleEditor.getAllClassesInPackage(string2, iJavaProject));
                    continue;
                }
                this.imports.add(string);
            }
        }
    }

    @Override
    public List<GlobalDescr> getGlobals() {
        if (this.globals == null) {
            this.loadGlobals();
        }
        return this.globals;
    }

    private void loadGlobals() {
        String[] stringArray = this.process.getGlobalNames();
        this.globals = new ArrayList<GlobalDescr>(stringArray.length);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.globals.add(new GlobalDescr(string, "java.lang.Object"));
            ++n2;
        }
    }

    private IJavaProject getJavaProject() {
        IEditorPart iEditorPart = this.getEditor();
        if (iEditorPart != null && iEditorPart.getEditorInput() instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorPart.getEditorInput()).getFile();
            try {
                if (iFile.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                    return JavaCore.create((IProject)iFile.getProject());
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void reset() {
        this.imports = null;
        this.globals = null;
    }
}

