/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowConstraintDialog;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.node.Split;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintListDialog
extends EditBeanDialog<Map<ConnectionRef, Constraint>> {
    private WorkflowProcess process;
    private Split split;
    private Map<ConnectionRef, Constraint> newMap;
    private Map<Connection, Label> labels = new HashMap<Connection, Label>();

    protected ConstraintListDialog(Shell shell, WorkflowProcess workflowProcess, Split split) {
        super(shell, "\u5236\u7d04\u306e\u7de8\u96c6");
        this.process = workflowProcess;
        this.split = split;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        List list = this.split.getDefaultOutgoingConnections();
        this.labels.clear();
        for (Connection connection : list) {
            Label label = new Label(composite2, 0);
            label.setText("\u9001\u308a\u5148\u30ce\u30fc\u30c9 " + connection.getTo().getName() + ": ");
            Label label2 = new Label(composite2, 0);
            this.labels.put(connection, label2);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            label2.setLayoutData((Object)gridData);
            Constraint constraint = this.newMap.get(new ConnectionRef(connection.getTo().getId(), connection.getToType()));
            if (constraint != null) {
                label2.setText(constraint.getName());
            }
            Button button = new Button(composite2, 0);
            button.setText("\u7de8\u96c6");
            button.addSelectionListener((SelectionListener)new EditButtonListener(connection));
        }
        return composite2;
    }

    @Override
    public void setValue(Map<ConnectionRef, Constraint> map) {
        super.setValue(map);
        this.newMap = new HashMap<ConnectionRef, Constraint>(map);
    }

    @Override
    protected Map<ConnectionRef, Constraint> updateValue(Map<ConnectionRef, Constraint> map) {
        return this.newMap;
    }

    private void editItem(final Connection connection) {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowConstraintDialog ruleFlowConstraintDialog = new RuleFlowConstraintDialog(ConstraintListDialog.this.getShell(), ConstraintListDialog.this.process);
                ruleFlowConstraintDialog.create();
                ConnectionRef connectionRef = new ConnectionRef(connection.getTo().getId(), connection.getToType());
                Constraint constraint = (Constraint)ConstraintListDialog.this.newMap.get(connectionRef);
                ruleFlowConstraintDialog.setConstraint(constraint);
                int n = ruleFlowConstraintDialog.open();
                if (n != 1) {
                    constraint = ruleFlowConstraintDialog.getConstraint();
                    ConstraintListDialog.this.newMap.put(connectionRef, constraint);
                    ConstraintListDialog.this.setConnectionText((Label)ConstraintListDialog.this.labels.get(connection), constraint.getName());
                }
            }
        };
        runnable.run();
    }

    private void setConnectionText(final Label label, final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                label.setText(string);
            }
        });
    }

    private class EditButtonListener
    extends SelectionAdapter {
        private Connection connection;

        public EditButtonListener(Connection connection) {
            this.connection = connection;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ConstraintListDialog.this.editItem(this.connection);
        }
    }
}

