/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ImportCompletionProcessor;
import org.drools.workflow.core.WorkflowProcess;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowImportsDialog
extends Dialog {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("\\n\\s*import\\s+([^\\s;#]+);?", 32);
    private static final Pattern FUNCTION_IMPORT_PATTERN = Pattern.compile("\\n\\s*import\\s+function\\s+([^\\s;#]+);?", 32);
    private WorkflowProcess process;
    private boolean success;
    private TabFolder tabFolder;
    private SourceViewer importsViewer;
    private List<String> imports;
    private List<String> functionImports;

    public RuleFlowImportsDialog(Shell shell, WorkflowProcess workflowProcess) {
        super(shell);
        this.process = workflowProcess;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("\u30a4\u30f3\u30dd\u30fc\u30c8\u30a8\u30c7\u30a3\u30bf");
    }

    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite composite) {
        this.importsViewer = new SourceViewer(composite, null, 2048);
        this.importsViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer iSourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                ImportCompletionProcessor importCompletionProcessor = new ImportCompletionProcessor();
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)importCompletionProcessor, "__dftl_partition_content_type");
                contentAssistant.setProposalPopupOrientation(10);
                return contentAssistant;
            }
        });
        Document document = new Document(this.getProcessImports());
        this.importsViewer.setDocument((IDocument)document);
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        fastPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)fastPartitioner);
        this.importsViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && keyEvent.stateMask == 262144) {
                    RuleFlowImportsDialog.this.importsViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        return this.importsViewer.getControl();
    }

    private String getProcessImports() {
        String string = "# \u3053\u3053\u306b\u30a4\u30f3\u30dd\u30fc\u30c8\u3092\u5b9a\u7fa9\u3057\u3066\u304f\u3060\u3055\u3044\uff1a\u4f8b\uff1a import com.sample.MyClass\n";
        List list = this.process.getImports();
        if (list != null) {
            for (String string2 : list) {
                string = String.valueOf(string) + "import " + string2 + "\n";
            }
        }
        if ((list = this.process.getFunctionImports()) != null) {
            for (String string2 : list) {
                string = String.valueOf(string) + "import function " + string2 + "\n";
            }
        }
        return string;
    }

    public Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        this.tabFolder = new TabFolder(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("\u30a4\u30f3\u30dd\u30fc\u30c8");
        tabItem.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    protected void okPressed() {
        this.success = true;
        this.updateImports();
        super.okPressed();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public List<String> getFunctionImports() {
        return this.functionImports;
    }

    private void updateImports() {
        this.imports = new ArrayList<String>();
        Matcher matcher = IMPORT_PATTERN.matcher(this.importsViewer.getDocument().get());
        while (matcher.find()) {
            String string = matcher.group(1);
            if ("function".equals(string)) continue;
            this.imports.add(string);
        }
        this.functionImports = new ArrayList<String>();
        matcher = FUNCTION_IMPORT_PATTERN.matcher(this.importsViewer.getDocument().get());
        while (matcher.find()) {
            this.functionImports.add(matcher.group(1));
        }
    }
}

