/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.launching;

import java.text.MessageFormat;
import org.drools.eclipse.launching.DroolsVMDebugger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;

public class DroolsJUnitLaunchConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        super.launch(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
        if (string.equals("debug")) {
            IBreakpoint[] iBreakpointArray = this.getDroolsBreakpoints();
            int n = 0;
            while (n < iBreakpointArray.length) {
                iLaunch.getDebugTarget().breakpointAdded(iBreakpointArray[n]);
                ++n;
            }
        }
    }

    private IBreakpoint[] getDroolsBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.drools.eclipse.debug");
    }

    public IVMRunner getVMRunner(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        IVMInstall iVMInstall = this.verifyVMInstall(iLaunchConfiguration);
        DroolsVMDebugger droolsVMDebugger = new DroolsVMDebugger(iVMInstall);
        if (droolsVMDebugger == null) {
            this.abort(MessageFormat.format(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_0, iVMInstall.getName(), string), null, 106);
        }
        return droolsVMDebugger;
    }
}

