/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DroolsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button buildAllCheckBox;
    private Button collapseEditorCheckBox;
    private Button cacheParsedRulesCheckBox;
    private Combo processSkinCombo;
    private Button allowNodeCustomizationCheckBox;
    private Combo internalAPICombo;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.buildAllCheckBox = this.createCheckBox(composite2, "Automatically reparse all rules if a Java resource is changed.");
        this.collapseEditorCheckBox = this.createCheckBox(composite2, "Use code folding in DRL editor.");
        this.cacheParsedRulesCheckBox = this.createCheckBox(composite2, "When parsing rules, always cache the result for future use. Warning: when disabled, debugging of rules will not work.");
        Label label = new Label(composite2, 0);
        label.setText("Preferred process skin: ");
        this.processSkinCombo = new Combo(composite2, 16392);
        this.processSkinCombo.add("default");
        this.processSkinCombo.add("BPMN");
        this.processSkinCombo.add("BPMN2");
        this.allowNodeCustomizationCheckBox = this.createCheckBox(composite2, "Allow the customization of process nodes.");
        label = new Label(composite2, 0);
        label.setText("Internal Drools classes are: ");
        this.internalAPICombo = new Combo(composite2, 16384);
        this.internalAPICombo.add("Accessible");
        this.internalAPICombo.add("Not accessible");
        this.internalAPICombo.add("Discouraged");
        this.initializeValues();
        return composite2;
    }

    private Button createCheckBox(Composite composite, String string) {
        Button button = new Button(composite, 16416);
        button.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DroolsEclipsePlugin.getDefault().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.buildAllCheckBox.setSelection(iPreferenceStore.getDefaultBoolean("Drools.BuildAll"));
        this.collapseEditorCheckBox.setSelection(iPreferenceStore.getDefaultBoolean("Drools.EditorFolding"));
        this.cacheParsedRulesCheckBox.setSelection(iPreferenceStore.getDefaultBoolean("Drools.CacheParsedRules"));
        String string = iPreferenceStore.getDefaultString("Drools.Flow.Skin");
        int n = 0;
        if ("BPMN".equals(string)) {
            n = 1;
        }
        this.processSkinCombo.select(n);
        this.allowNodeCustomizationCheckBox.setSelection(iPreferenceStore.getDefaultBoolean("Drools.Flow.AllowNodeCustomization"));
        this.internalAPICombo.select(iPreferenceStore.getDefaultInt("Drools.Flow.AllowNodeCustomization"));
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.buildAllCheckBox.setSelection(iPreferenceStore.getBoolean("Drools.BuildAll"));
        this.collapseEditorCheckBox.setSelection(iPreferenceStore.getBoolean("Drools.EditorFolding"));
        this.cacheParsedRulesCheckBox.setSelection(iPreferenceStore.getBoolean("Drools.CacheParsedRules"));
        String string = iPreferenceStore.getString("Drools.Flow.Skin");
        int n = 0;
        if ("BPMN".equals(string)) {
            n = 1;
        }
        if ("BPMN2".equals(string)) {
            n = 2;
        }
        this.processSkinCombo.select(n);
        this.allowNodeCustomizationCheckBox.setSelection(iPreferenceStore.getBoolean("Drools.Flow.AllowNodeCustomization"));
        this.internalAPICombo.select(iPreferenceStore.getInt("Drools.InternalAPI"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        DroolsEclipsePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("Drools.BuildAll", this.buildAllCheckBox.getSelection());
        iPreferenceStore.setValue("Drools.EditorFolding", this.collapseEditorCheckBox.getSelection());
        iPreferenceStore.setValue("Drools.CacheParsedRules", this.cacheParsedRulesCheckBox.getSelection());
        iPreferenceStore.setValue("Drools.Flow.Skin", this.processSkinCombo.getItem(this.processSkinCombo.getSelectionIndex()));
        iPreferenceStore.setValue("Drools.Flow.AllowNodeCustomization", this.allowNodeCustomizationCheckBox.getSelection());
        iPreferenceStore.setValue("Drools.InternalAPI", this.internalAPICombo.getSelectionIndex());
    }

    public void init(IWorkbench iWorkbench) {
    }
}

