/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DroolsProjectPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.drools.eclipse.preferences.DroolsRuntimesPreferencePage";
    public static final String PROP_ID = "org.drools.eclipse.preferences.DroolsProjectPreferencePage";
    private Combo droolsRuntimeCombo;

    public DroolsProjectPreferencePage() {
        this.setTitle("Drools Project Preferences");
    }

    protected Control createPreferenceContent(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Drools Runtime: ");
        this.droolsRuntimeCombo = new Combo(composite2, 16384);
        DroolsRuntime[] droolsRuntimeArray = DroolsRuntimeManager.getDroolsRuntimes();
        int n = -1;
        String string = DroolsRuntimeManager.getDroolsRuntime(this.getProject());
        int n2 = 0;
        while (n2 < droolsRuntimeArray.length) {
            this.droolsRuntimeCombo.add(droolsRuntimeArray[n2].getName());
            if (droolsRuntimeArray[n2].getName().equals(string)) {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            this.droolsRuntimeCombo.select(n);
        } else if (droolsRuntimeArray.length > 0) {
            this.droolsRuntimeCombo.select(0);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.droolsRuntimeCombo.setLayoutData((Object)gridData);
        return composite2;
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected boolean hasProjectSpecificOptions(IProject iProject) {
        return iProject.getFile(".settings/.drools.runtime").exists();
    }

    public boolean performOk() {
        try {
            IFile iFile = this.getProject().getFile(".settings/.drools.runtime");
            if (this.useProjectSettings()) {
                String string = "<runtime>" + this.droolsRuntimeCombo.getItem(this.droolsRuntimeCombo.getSelectionIndex()) + "</runtime>";
                if (!iFile.exists()) {
                    IFolder iFolder = this.getProject().getFolder(".settings");
                    if (!iFolder.exists()) {
                        iFolder.create(true, true, null);
                    }
                    iFile.create((InputStream)new ByteArrayInputStream(string.getBytes()), true, null);
                } else {
                    iFile.setContents((InputStream)new ByteArrayInputStream(string.getBytes()), true, false, null);
                }
            } else if (iFile.exists()) {
                iFile.delete(true, null);
            }
            this.getProject().close(null);
            this.getProject().open(null);
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
            return false;
        }
        return super.performOk();
    }
}

