/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import java.io.File;
import java.util.List;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsRuntimeDialog
extends Dialog {
    private DroolsRuntime runtime;
    private Text nameText;
    private Text pathText;
    private List<DroolsRuntime> runtimes;
    private Listener textModifyListener = new Listener(){

        public void handleEvent(Event event) {
            boolean bl = DroolsRuntimeDialog.this.validate();
            DroolsRuntimeDialog.this.getButton(0).setEnabled(bl);
        }
    };

    public DroolsRuntimeDialog(Shell shell, List<DroolsRuntime> list) {
        super(shell);
        this.setBlockOnOpen(true);
        this.runtimes = list;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setFont(composite2.getFont());
        label.setText("\u30d5\u30a1\u30a4\u30eb\u30b7\u30b9\u30c6\u30e0\u306e\u65e2\u5b58Drools\u30e9\u30f3\u30bf\u30a4\u30e0\u3092\u9078\u629e\u3059\u308b\u304b\u3001\u65b0\u3057\u3044\u306e\u3092\u4f5c\u6210\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 450;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        label2.setText("\u540d\u524d\uff1a ");
        this.nameText = new Text(composite2, 0);
        this.nameText.setText(this.runtime == null || this.runtime.getName() == null ? "" : this.runtime.getName());
        this.nameText.addListener(24, this.textModifyListener);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("\u30d1\u30b9\uff1a ");
        this.pathText = new Text(composite2, 0);
        this.pathText.setText(this.runtime == null || this.runtime.getPath() == null ? "" : this.runtime.getPath());
        this.pathText.addListener(24, this.textModifyListener);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.pathText.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 16392);
        button.setText("\u53c2\u7167 ...");
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DroolsRuntimeDialog.this.browse();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button2 = new Button(composite2, 16392);
        button2.setText("Drools 5\u30e9\u30f3\u30bf\u30a4\u30e0\u3092\u4f5c\u6210 ...");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DroolsRuntimeDialog.this.createRuntime();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.getButton(0).setEnabled(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Drools\u30e9\u30f3\u30bf\u30a4\u30e0");
    }

    protected Point getInitialSize() {
        return new Point(500, 250);
    }

    public void setDroolsRuntime(DroolsRuntime droolsRuntime) {
        this.runtime = droolsRuntime;
    }

    private boolean validate() {
        Object object;
        Object object2;
        String string = this.nameText.getText();
        if (string == null || "".equals(string.trim())) {
            return false;
        }
        if (this.runtime == null || !string.equals(this.runtime.getName())) {
            object2 = this.runtimes.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!string.equals(((DroolsRuntime)object).getName())) continue;
                return false;
            }
        }
        return (object = this.pathText.getText()) != null && ((File)(object2 = new File((String)object))).exists() && ((File)object2).isDirectory();
    }

    private void browse() {
        String string = null;
        String string2 = this.pathText.getText();
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage("Drools\u30e9\u30f3\u30bf\u30a4\u30e0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        directoryDialog.setFilterPath(string2);
        string = directoryDialog.open();
        if (string != null) {
            this.pathText.setText(string);
        }
    }

    private void createRuntime() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage("\u65b0\u3057\u3044Drools5\u30e9\u30f3\u30bf\u30a4\u30e0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        String string = directoryDialog.open();
        if (string != null) {
            DroolsRuntimeManager.createDefaultRuntime(string);
            this.nameText.setText("Drools 5.1.0\u30e9\u30f3\u30bf\u30a4\u30e0");
            this.pathText.setText(string);
        }
    }

    public DroolsRuntime getResult() {
        return this.runtime;
    }

    protected void okPressed() {
        this.runtime = new DroolsRuntime();
        this.runtime.setName(this.nameText.getText());
        this.runtime.setPath(this.pathText.getText());
        super.okPressed();
    }
}

