/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.preferences.DroolsRuntimeDialog;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DroolsRuntimesBlock
implements ISelectionProvider {
    private Composite fControl;
    private List<DroolsRuntime> droolsRuntimes = new ArrayList<DroolsRuntime>();
    private CheckboxTableViewer droolsRuntimesList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.add((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.droolsRuntimesList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.remove((Object)iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.equals(this.fPrevSelection)) {
            this.fPrevSelection = iSelection;
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object == null) {
                this.droolsRuntimesList.setCheckedElements(new Object[0]);
            } else {
                this.droolsRuntimesList.setCheckedElements(new Object[]{object});
                this.droolsRuntimesList.reveal(object);
            }
            this.fireSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    public void createControl(Composite composite) {
        Composite composite2;
        Font font = composite.getFont();
        this.fControl = composite2 = SWTFactory.createComposite((Composite)composite, (Font)font, (int)2, (int)1, (int)1808);
        SWTFactory.createLabel((Composite)composite2, (String)"\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308bDrools\u30e9\u30f3\u30bf\u30a4\u30e0", (int)2);
        this.fTable = new Table(composite2, 67618);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 350;
        this.fTable.setLayoutData((Object)gridData);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.fTable, 0);
        tableColumn.setText("\u540d\u524d");
        int n = 176;
        tableColumn.setWidth(n);
        tableColumn = new TableColumn(this.fTable, 0);
        tableColumn.setText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        tableColumn.setWidth(n);
        this.droolsRuntimesList = new CheckboxTableViewer(this.fTable);
        this.droolsRuntimesList.setLabelProvider((IBaseLabelProvider)new DroolsRuntimesLabelProvider());
        this.droolsRuntimesList.setContentProvider((IContentProvider)new DroolsRuntimesContentProvider());
        this.droolsRuntimesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DroolsRuntimesBlock.this.enableButtons();
            }
        });
        this.droolsRuntimesList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                if (checkStateChangedEvent.getChecked()) {
                    DroolsRuntimesBlock.this.setDefaultDroolsRuntime((DroolsRuntime)checkStateChangedEvent.getElement());
                } else {
                    DroolsRuntimesBlock.this.setDefaultDroolsRuntime(null);
                }
            }
        });
        this.droolsRuntimesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (!DroolsRuntimesBlock.this.droolsRuntimesList.getSelection().isEmpty()) {
                    DroolsRuntimesBlock.this.editDroolsRuntime();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && DroolsRuntimesBlock.this.fRemoveButton.isEnabled()) {
                    DroolsRuntimesBlock.this.removeDroolsRuntimes();
                }
            }
        });
        Composite composite3 = SWTFactory.createComposite((Composite)composite2, (Font)font, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTFactory.createPushButton((Composite)composite3, (String)"\u8ffd\u52a0...", null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DroolsRuntimesBlock.this.addDroolsRuntime();
            }
        });
        this.fEditButton = SWTFactory.createPushButton((Composite)composite3, (String)"\u7de8\u96c6...", null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DroolsRuntimesBlock.this.editDroolsRuntime();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton((Composite)composite3, (String)"\u524a\u9664", null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DroolsRuntimesBlock.this.removeDroolsRuntimes();
            }
        });
        SWTFactory.createVerticalSpacer((Composite)composite2, (int)1);
        this.enableButtons();
        this.fAddButton.setEnabled(true);
    }

    private void enableButtons() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.droolsRuntimesList.getSelection();
        int n = iStructuredSelection.size();
        this.fEditButton.setEnabled(n == 1);
        this.fRemoveButton.setEnabled(n > 0);
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setDroolsRuntimes(DroolsRuntime[] droolsRuntimeArray) {
        this.droolsRuntimes.clear();
        int n = 0;
        while (n < droolsRuntimeArray.length) {
            this.droolsRuntimes.add(droolsRuntimeArray[n]);
            ++n;
        }
        this.droolsRuntimesList.setInput(this.droolsRuntimes);
        this.droolsRuntimesList.refresh();
    }

    public DroolsRuntime[] getDroolsRuntimes() {
        DroolsRuntime droolsRuntime = this.getDefaultDroolsRuntime();
        for (DroolsRuntime droolsRuntime2 : this.droolsRuntimes) {
            droolsRuntime2.setDefault(droolsRuntime2.equals(droolsRuntime));
        }
        return this.droolsRuntimes.toArray(new DroolsRuntime[this.droolsRuntimes.size()]);
    }

    private void addDroolsRuntime() {
        DroolsRuntime droolsRuntime;
        DroolsRuntimeDialog droolsRuntimeDialog = new DroolsRuntimeDialog(this.getShell(), this.droolsRuntimes);
        if (droolsRuntimeDialog.open() == 0 && (droolsRuntime = droolsRuntimeDialog.getResult()) != null) {
            DroolsRuntimeManager.recognizeJars(droolsRuntime);
            this.droolsRuntimes.add(droolsRuntime);
            this.droolsRuntimesList.refresh();
            this.droolsRuntimesList.setSelection((ISelection)new StructuredSelection((Object)droolsRuntime));
        }
    }

    private void editDroolsRuntime() {
        DroolsRuntime droolsRuntime;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.droolsRuntimesList.getSelection();
        DroolsRuntime droolsRuntime2 = (DroolsRuntime)iStructuredSelection.getFirstElement();
        if (droolsRuntime2 == null) {
            return;
        }
        DroolsRuntimeDialog droolsRuntimeDialog = new DroolsRuntimeDialog(this.getShell(), this.droolsRuntimes);
        droolsRuntimeDialog.setDroolsRuntime(droolsRuntime2);
        if (droolsRuntimeDialog.open() == 0 && (droolsRuntime = droolsRuntimeDialog.getResult()) != null) {
            DroolsRuntimeManager.recognizeJars(droolsRuntime);
            int n = this.droolsRuntimes.indexOf(droolsRuntime2);
            this.droolsRuntimes.remove(n);
            this.droolsRuntimes.add(n, droolsRuntime);
            this.droolsRuntimesList.refresh();
            this.droolsRuntimesList.setSelection((ISelection)new StructuredSelection((Object)droolsRuntime));
        }
    }

    private void removeDroolsRuntimes() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.droolsRuntimesList.getSelection();
        DroolsRuntime[] droolsRuntimeArray = new DroolsRuntime[iStructuredSelection.size()];
        Iterator iterator = iStructuredSelection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            droolsRuntimeArray[n] = (DroolsRuntime)iterator.next();
            ++n;
        }
        this.removeDroolsRuntimes(droolsRuntimeArray);
    }

    public void removeDroolsRuntimes(DroolsRuntime[] droolsRuntimeArray) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        int n = 0;
        while (n < droolsRuntimeArray.length) {
            this.droolsRuntimes.remove(droolsRuntimeArray[n]);
            ++n;
        }
        this.droolsRuntimesList.refresh();
        IStructuredSelection iStructuredSelection2 = (IStructuredSelection)this.getSelection();
        if (!iStructuredSelection2.equals(iStructuredSelection)) {
            droolsRuntimeArray = this.getDroolsRuntimes();
            if (iStructuredSelection2.size() == 0 && droolsRuntimeArray.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)droolsRuntimeArray[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void setDefaultDroolsRuntime(DroolsRuntime droolsRuntime) {
        if (droolsRuntime == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)droolsRuntime));
        }
    }

    public DroolsRuntime getDefaultDroolsRuntime() {
        Object[] objectArray = this.droolsRuntimesList.getCheckedElements();
        if (objectArray.length == 0) {
            return null;
        }
        return (DroolsRuntime)objectArray[0];
    }

    class DroolsRuntimesContentProvider
    implements IStructuredContentProvider {
        DroolsRuntimesContentProvider() {
        }

        public Object[] getElements(Object object) {
            return DroolsRuntimesBlock.this.droolsRuntimes.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    class DroolsRuntimesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DroolsRuntimesLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof DroolsRuntime) {
                DroolsRuntime droolsRuntime = (DroolsRuntime)object;
                switch (n) {
                    case 0: {
                        return droolsRuntime.getName();
                    }
                    case 1: {
                        return droolsRuntime.getPath();
                    }
                }
            }
            return object.toString();
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }
    }
}

