/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.refactoring.DRLProjectDetector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RuleIFileRenameParticipant
extends RenameParticipant {
    public static final String NAME = "Rule File Rename Refactoring";
    private DRLProjectDetector drlProjectDetector = new DRLProjectDetector();
    private Matcher matcher;
    private RefactoringProcessor processor;
    private List<IFile> drlFiles;
    private IFile file;
    private String newName;
    private String currentName;

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.file == null || this.file.isReadOnly()) {
            refactoringStatus.addFatalError("File don't exists or is read only");
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = null;
        compositeChange = new CompositeChange("Reorganize DRL " + this.currentName + " Type ");
        this.drlFiles = this.drlProjectDetector.detect(this.file.getProject());
        for (IFile iFile : this.drlFiles) {
            String string = this.readFile(iFile);
            if (string == null) {
                return null;
            }
            Pattern pattern = Pattern.compile("(?<=\\.|\\s)" + this.currentName + "(?=\\(|\\n|\\s)");
            this.matcher = pattern.matcher(string);
            TextFileChange textFileChange = new TextFileChange(iFile.getName(), iFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textFileChange.setEdit((TextEdit)multiTextEdit);
            while (this.matcher.find()) {
                ReplaceEdit replaceEdit = new ReplaceEdit(this.matcher.start(), this.currentName.length(), this.newName);
                multiTextEdit.addChild((TextEdit)replaceEdit);
            }
            if (textFileChange.getEdit().getChildrenSize() <= 0) continue;
            compositeChange.add((Change)textFileChange);
        }
        if (compositeChange.getChildren().length == 0) {
            return null;
        }
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    public String getName() {
        return NAME;
    }

    protected boolean initialize(Object object) {
        IFile iFile;
        if (object instanceof IFile && (iFile = (IFile)object).getType() == 1 && iFile.getFileExtension().equalsIgnoreCase("java")) {
            this.processor = this.getProcessor();
            this.file = iFile;
            if (this.processor instanceof JavaRenameProcessor) {
                this.newName = ((JavaRenameProcessor)this.processor).getNewElementName().replace(".java", "");
                this.currentName = ((JavaRenameProcessor)this.processor).getCurrentElementName();
                return true;
            }
        }
        return false;
    }

    private String readFile(IFile iFile) throws CoreException {
        InputStream inputStream = iFile.getContents();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(String.valueOf(string) + "\n");
                }
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return stringBuilder.toString();
    }
}

