/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.refactoring.DRLProjectDetector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RuleSourceFieldRenameParticipant
extends RenameParticipant {
    public static final String NAME = "Rule Source Field Rename Refactoring";
    private static final String FIELD_NAME = "(?<=:\\s)FIELD_NAME|FIELD_NAME(?=\\s=)";
    private static final String VARIABLE_ASSIGNED = "[\\w]*(?=\\s*:\\s*TYPE\\s*\\()";
    private static final String GETTER_NAME = "(?<=VARIABLE_NAME\\.)CURRENT_GETTER_NAME(?=\\s*\\()";
    private static final String SETTER_NAME = "(?<=VARIABLE_NAME\\.)CURRENT_SETTER_NAME(?=\\s*\\()";
    private DRLProjectDetector drlProjectDetector = new DRLProjectDetector();
    private Matcher matcher;
    private RefactoringProcessor processor;
    private List<IFile> drlFiles;
    private SourceField sourceField;
    private String newName;
    private String currentName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        try {
            IFile iFile = this.getSourceFieldIFile();
            if (iFile == null) return refactoringStatus;
            if (iFile.isReadOnly()) {
                return refactoringStatus;
            }
            this.drlFiles = this.drlProjectDetector.detect(iFile.getProject());
            String string = null;
            Iterator<IFile> iterator = this.drlFiles.iterator();
            do {
                if (!iterator.hasNext()) {
                    return refactoringStatus;
                }
                IFile iFile2 = iterator.next();
                string = this.readFile(iFile2);
                if (string == null) {
                    return null;
                }
                Pattern pattern = Pattern.compile("(?<=:\\s)" + this.currentName + "|" + this.currentName + "(?=\\s=)");
                this.matcher = pattern.matcher(string);
            } while (!this.matcher.find());
            RenameFieldProcessor renameFieldProcessor = (RenameFieldProcessor)this.processor;
            if (renameFieldProcessor.getRenameGetter()) return refactoringStatus;
            refactoringStatus.addInfo("The getter must be also updated to refactor the DRL files.");
            return refactoringStatus;
        }
        catch (CoreException coreException) {
            throw new OperationCanceledException(coreException.getMessage());
        }
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = null;
        compositeChange = new CompositeChange("Fix " + this.currentName + " field on DRL files");
        IFile iFile = this.getSourceFieldIFile();
        String string = this.sourceField.getParent().getElementName();
        if (iFile != null) {
            RenameFieldProcessor renameFieldProcessor = (RenameFieldProcessor)this.processor;
            for (IFile iFile2 : this.drlFiles) {
                Object object;
                String string2 = this.readFile(iFile2);
                if (string2 == null) {
                    return null;
                }
                TextFileChange textFileChange = new TextFileChange(iFile2.getName(), iFile2);
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                textFileChange.setEdit((TextEdit)multiTextEdit);
                Pattern pattern = Pattern.compile(FIELD_NAME.replaceAll("FIELD_NAME", this.currentName));
                this.matcher = pattern.matcher(string2);
                while (this.matcher.find()) {
                    object = new ReplaceEdit(this.matcher.start(), this.currentName.length(), this.newName);
                    multiTextEdit.addChild((TextEdit)object);
                }
                pattern = Pattern.compile(VARIABLE_ASSIGNED.replace("TYPE", string));
                this.matcher = pattern.matcher(string2);
                while (this.matcher.find()) {
                    String string3;
                    String string4;
                    String string5;
                    if (this.matcher.group().length() <= 0) continue;
                    object = this.matcher.group();
                    if (renameFieldProcessor.getRenameGetter()) {
                        string5 = renameFieldProcessor.getNewGetterName();
                        string4 = renameFieldProcessor.getGetter().getElementName();
                        string3 = GETTER_NAME.replace("VARIABLE_NAME", (CharSequence)object).replace("CURRENT_GETTER_NAME", string4);
                        this.createFieldRenameChanges(multiTextEdit, string2, string3, string4, string5);
                    }
                    if (!renameFieldProcessor.getRenameSetter()) continue;
                    string5 = renameFieldProcessor.getNewSetterName();
                    string4 = renameFieldProcessor.getSetter().getElementName();
                    string3 = SETTER_NAME.replace("VARIABLE_NAME", (CharSequence)object).replace("CURRENT_SETTER_NAME", string4);
                    this.createFieldRenameChanges(multiTextEdit, string2, string3, string4, string5);
                }
                if (textFileChange.getEdit().getChildrenSize() <= 0) continue;
                compositeChange.add((Change)textFileChange);
            }
        }
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    private void createFieldRenameChanges(MultiTextEdit multiTextEdit, String string, String string2, String string3, String string4) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        ReplaceEdit replaceEdit = null;
        while (matcher.find()) {
            replaceEdit = new ReplaceEdit(matcher.start(), string3.length(), string4);
            multiTextEdit.addChild((TextEdit)replaceEdit);
        }
    }

    public String getName() {
        return NAME;
    }

    private IFile getSourceFieldIFile() {
        try {
            SearchResultGroup[] searchResultGroupArray;
            Field field = this.processor.getClass().getDeclaredField("fReferences");
            field.setAccessible(true);
            SearchResultGroup[] searchResultGroupArray2 = searchResultGroupArray = (SearchResultGroup[])field.get(this.processor);
            int n = searchResultGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchResultGroup searchResultGroup = searchResultGroupArray2[n2];
                if (searchResultGroup.getResource() instanceof IFile) {
                    return (IFile)searchResultGroup.getResource();
                }
                ++n2;
            }
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        return null;
    }

    protected boolean initialize(Object object) {
        if (object instanceof SourceField) {
            this.sourceField = (SourceField)object;
            this.processor = this.getProcessor();
            if (this.processor instanceof JavaRenameProcessor) {
                this.newName = ((JavaRenameProcessor)this.processor).getNewElementName();
                this.currentName = ((JavaRenameProcessor)this.processor).getCurrentElementName();
                return true;
            }
        }
        return false;
    }

    private String readFile(IFile iFile) throws CoreException {
        InputStream inputStream = iFile.getContents();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(String.valueOf(string) + "\n");
                }
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return stringBuilder.toString();
    }
}

