/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import org.drools.compiler.DrlParser;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.dsl.editor.DSLAdapter;
import org.drools.eclipse.editors.DRLDocumentProvider;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.rulebuilder.editors.BrlPage;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class RuleEditor
extends FormEditor
implements IResourceChangeListener {
    private BrlPage guidedEditor;
    private TextEditor xmlEditor = new TextEditor();
    private SuggestionCompletionEngine completion;
    private SuggestionCompletionLoader loader;
    private FileEditorInput packageEditorInput;
    private final Document drlDocument;
    private IResourceChangeListener packageFileTracker = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IPath iPath;
            IResourceDelta iResourceDelta;
            IPath iPath2;
            if (RuleEditor.this.packageEditorInput != null && (iPath2 = (iResourceDelta = RuleEditor.this.getRootDelta(iResourceChangeEvent.getDelta())).getFullPath()).equals((Object)(iPath = RuleEditor.this.packageEditorInput.getFile().getFullPath()))) {
                RuleEditor.this.reloadCompletionEngine();
            }
        }
    };

    public RuleEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.packageFileTracker, 1);
        this.drlDocument = new Document();
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(DroolsEclipsePlugin.getDefault().getRuleBuilderFormColors(display));
    }

    protected void addPages() {
        this.guidedEditor = new BrlPage(this);
        try {
            this.addPage((IFormPage)this.guidedEditor);
            this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            DRLRuleEditor dRLRuleEditor = new DRLRuleEditor(){

                protected IDocumentProvider createDocumentProvider() {
                    return new DRLDocumentProvider(){

                        public boolean isReadOnly(Object object) {
                            return true;
                        }

                        public boolean isModifiable(Object object) {
                            return false;
                        }

                        protected IDocument getParentDocument(Object object) {
                            return RuleEditor.this.drlDocument;
                        }
                    };
                }
            };
            this.addPage((IEditorPart)dRLRuleEditor, this.xmlEditor.getEditorInput());
            IPath iPath = this.getCurrentDirectoryPath(this.getEditorInput());
            if (iPath != null) {
                iPath = iPath.append("drools.package");
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
                IJavaProject iJavaProject = JavaCore.create((IProject)iFile.getProject());
                URLClassLoader uRLClassLoader = ProjectClassLoader.getProjectClassLoader(iJavaProject);
                this.loader = new SuggestionCompletionLoader((ClassLoader)uRLClassLoader);
                if (!iFile.exists()) {
                    String string = "//This is a package configuration file";
                    string = String.valueOf(string) + "\n//Add imports, globals etc here which will be used by all the rule assets in this folder.";
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    try {
                        iFile.create((InputStream)byteArrayInputStream, true, null);
                    }
                    catch (CoreException coreException) {
                        DroolsEclipsePlugin.log(coreException);
                    }
                }
                this.packageEditorInput = new FileEditorInput(iFile);
            }
            this.reloadCompletionEngine();
            this.setPageText(1, "BRL Source");
            this.setPageText(2, "Generated DRL (read-only)");
            this.updateName(false);
        }
        catch (PartInitException partInitException) {
            DroolsEclipsePlugin.log(partInitException);
        }
    }

    private void updateName(boolean bl) {
        String string = this.xmlEditor.getTitle();
        this.setPartName(string);
        if (this.guidedEditor.getModeller() != null && this.guidedEditor.getModeller().getModel() != null && (this.guidedEditor.getModeller().getModel().name == null || bl)) {
            String string2;
            this.guidedEditor.getModeller().getModel().name = string2 = string.substring(0, string.length() - ".brl".length());
        }
        this.updateDRLPage();
    }

    private IPath getCurrentDirectoryPath(IEditorInput iEditorInput) {
        if (iEditorInput instanceof FileEditorInput) {
            return ((FileEditorInput)iEditorInput).getFile().getFullPath().removeLastSegments(1).addTrailingSeparator();
        }
        return null;
    }

    private void reloadCompletionEngine() {
        if (this.packageEditorInput == null) {
            this.completion = new SuggestionCompletionLoader(null).getSuggestionEngine("", new ArrayList(), new ArrayList());
            return;
        }
        try {
            IPath iPath = this.packageEditorInput.getFile().getFullPath().removeLastSegments(1);
            Container container = (Container)ResourcesPlugin.getWorkspace().getRoot().findMember(iPath, false);
            IResource[] iResourceArray = container.members(false);
            ArrayList<DSLTokenizedMappingFile> arrayList = new ArrayList<DSLTokenizedMappingFile>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            while (n < iResourceArray.length) {
                String string;
                String string2 = iResourceArray[n].getName();
                if (string2.endsWith(".dsl")) {
                    DSLTokenizedMappingFile dSLTokenizedMappingFile = new DSLTokenizedMappingFile();
                    string = this.getFileContents((IFile)iResourceArray[n]);
                    if (dSLTokenizedMappingFile.parseAndLoad((Reader)new StringReader(string))) {
                        arrayList.add(dSLTokenizedMappingFile);
                    }
                } else if (string2.endsWith(".enumeration")) {
                    string = this.getFileContents((IFile)iResourceArray[n]);
                    arrayList2.add(string);
                }
                ++n;
            }
            String string = this.getFileContents(this.packageEditorInput.getFile());
            this.completion = this.loader.getSuggestionEngine(string, Collections.EMPTY_LIST, arrayList, arrayList2);
        }
        catch (Exception exception) {
            DroolsEclipsePlugin.log(exception);
        }
    }

    private String getFileContents(IFile iFile) {
        try {
            int n;
            InputStream inputStream = iFile.getContents();
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            return stringBuffer.toString();
        }
        catch (CoreException coreException) {
            return "";
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public boolean isDirty() {
        return this.xmlEditor.isDirty() || this.guidedEditor.isDirty();
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        IDocument iDocument = this.getInputDocument();
        if (n == 0) {
            boolean bl;
            boolean bl2 = bl = this.guidedEditor.getModeller().getModel() == null;
            if (this.xmlEditor.isDirty() || bl) {
                this.guidedEditor.setModelXML(iDocument.get());
                if (bl) {
                    this.guidedEditor.getModeller().setDirty(false);
                }
                this.updateName(false);
            }
            this.guidedEditor.refresh();
        } else if (n == 1) {
            if (this.guidedEditor.isDirty()) {
                iDocument.set(BRXMLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel()));
            }
        } else if (n == 2) {
            if (this.guidedEditor.isDirty()) {
                iDocument.set(BRXMLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel()));
            } else if (this.xmlEditor.isDirty()) {
                this.guidedEditor.setModelXML(iDocument.get());
            }
            this.updateDRLPage();
            this.updateName(false);
        }
    }

    private void updateDRLPage() {
        String string = "";
        try {
            string = BRDRLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel());
            IResource iResource = ResourceUtil.getResource((IEditorInput)this.xmlEditor.getEditorInput());
            Reader reader = DSLAdapter.getDSLContent(string, iResource);
            DrlParser drlParser = new DrlParser();
            if (reader != null) {
                string = drlParser.getExpandedDRL(string, reader);
            }
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            string = "\nPROBLEM WITH THE DRL CONVERSION!\n\n\nDRL:\n" + string + "\n\nSTACKTRACE:\n" + stringWriter.toString();
        }
        this.drlDocument.set(string);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        IDocument iDocument = this.getInputDocument();
        if (this.xmlEditor.isDirty()) {
            this.guidedEditor.setModelXML(iDocument.get());
        } else if (this.guidedEditor.isDirty()) {
            iDocument.set(BRXMLPersistence.getInstance().marshal(this.guidedEditor.getRuleModel()));
        }
        this.xmlEditor.doSave(iProgressMonitor);
        this.guidedEditor.getModeller().setDirty(false);
        this.guidedEditor.refresh();
    }

    private IDocument getInputDocument() {
        IEditorInput iEditorInput = this.getEditorInput();
        IDocumentProvider iDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(iEditorInput);
        IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
        return iDocument;
    }

    public void doSaveAs() {
        this.xmlEditor.doSaveAs();
        this.guidedEditor.getModeller().setDirty(false);
        this.updateName(true);
        this.setInput(this.xmlEditor.getEditorInput());
        this.guidedEditor.refresh();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = RuleEditor.this.getSite().getWorkbenchWindow().getPages();
                    int n = 0;
                    while (n < iWorkbenchPageArray.length) {
                        if (((FileEditorInput)RuleEditor.this.xmlEditor.getEditorInput()).getFile().getProject().equals((Object)iResourceChangeEvent.getResource())) {
                            IEditorPart iEditorPart = iWorkbenchPageArray[n].findEditor(RuleEditor.this.xmlEditor.getEditorInput());
                            iWorkbenchPageArray[n].closeEditor(iEditorPart, true);
                        }
                        ++n;
                    }
                }
            });
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.packageFileTracker);
        super.dispose();
    }

    public void dirtyPropertyChanged() {
        this.firePropertyChange(257);
        this.guidedEditor.refresh();
    }

    public SuggestionCompletionEngine getCompletionEngine() {
        return this.completion;
    }

    private IResourceDelta getRootDelta(IResourceDelta iResourceDelta) {
        if (iResourceDelta.getAffectedChildren().length > 0) {
            return this.getRootDelta(iResourceDelta.getAffectedChildren()[0]);
        }
        return iResourceDelta;
    }
}

