/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.AddNewInsertedFactFieldDialog;
import org.drools.eclipse.rulebuilder.ui.NumericKeyFilter;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ActionInsertFactWidget
extends Widget {
    private final ActionInsertFact fact;

    public ActionInsertFactWidget(FormToolkit formToolkit, Composite composite, RuleModeller ruleModeller, ActionInsertFact actionInsertFact, int n) {
        super(composite, formToolkit, ruleModeller, n);
        this.fact = actionInsertFact;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.create();
    }

    private void create() {
        String string = "assert";
        if (this.fact instanceof ActionInsertLogicalFact) {
            string = "assertLogical";
        }
        this.toolkit.createLabel(this.parent, String.valueOf(HumanReadable.getActionDisplayName(string)) + " " + this.fact.factType);
        this.addDeleteRHSAction();
        this.addMoreOptionsAction();
        Composite composite = this.toolkit.createComposite(this.parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.createConstraintRows(composite);
        this.toolkit.paintBordersFor(composite);
    }

    private void addMoreOptionsAction() {
        final Shell shell = new Shell(Display.getCurrent());
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/new_item.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                AddNewInsertedFactFieldDialog addNewInsertedFactFieldDialog = new AddNewInsertedFactFieldDialog(shell, ActionInsertFactWidget.this.getModeller(), ActionInsertFactWidget.this.fact);
                addNewInsertedFactFieldDialog.open();
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Add another field to this so you can set its value");
    }

    private void createConstraintRows(Composite composite) {
        int n = 0;
        while (n < this.fact.fieldValues.length) {
            ActionFieldValue actionFieldValue = this.fact.fieldValues[n];
            this.toolkit.createLabel(composite, actionFieldValue.field);
            this.valueEditor(composite, actionFieldValue);
            this.addRemoveFieldAction(composite, n);
            ++n;
        }
    }

    private void addRemoveFieldAction(Composite composite, final int n) {
        ImageHyperlink imageHyperlink = this.addImage(composite, "icons/delete_item_small.gif");
        imageHyperlink.setToolTipText("Remove this field action");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this item?");
                messageBox.setText("Remove this item?");
                if (messageBox.open() == 64) {
                    ActionInsertFactWidget.this.fact.removeField(n);
                    ActionInsertFactWidget.this.getModeller().setDirty(true);
                    ActionInsertFactWidget.this.getModeller().reloadRhs();
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
    }

    private void valueEditor(Composite composite, final ActionFieldValue actionFieldValue) {
        String cfr_ignored_0 = actionFieldValue.field;
        DropDownData dropDownData = this.modeller.getSuggestionCompletionEngine().getEnums(this.fact.factType, this.fact.fieldValues, actionFieldValue.field);
        boolean bl = false;
        if (dropDownData != null && dropDownData.fixedList.length > 0) {
            String[] stringArray = dropDownData.fixedList;
            final Combo combo = new Combo(composite, 12);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                combo.add(string);
                if (string.equals(actionFieldValue.value)) {
                    combo.select(n);
                    bl = true;
                }
                ++n;
            }
            if (!bl && actionFieldValue.value != null) {
                combo.add(actionFieldValue.value);
                combo.select(combo.getItemCount() - 1);
            }
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    actionFieldValue.value = combo.getItem(combo.getSelectionIndex());
                    ActionInsertFactWidget.this.modeller.reloadRhs();
                    ActionInsertFactWidget.this.modeller.setDirty(true);
                }
            });
        } else {
            final Text text = this.toolkit.createText(composite, "");
            if (actionFieldValue.value != null) {
                text.setText(actionFieldValue.value);
            }
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.minimumWidth = 100;
            text.setLayoutData((Object)gridData);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    ActionInsertFactWidget.this.getModeller().setDirty(true);
                    actionFieldValue.value = text.getText();
                }
            });
            if (actionFieldValue.type.equals("Numeric")) {
                new NumericKeyFilter(text);
            }
        }
    }

    public SuggestionCompletionEngine getCompletion() {
        return this.getModeller().getSuggestionCompletionEngine();
    }
}

