/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class AddCompositeConstraintOptionDialog
extends RuleDialog {
    private RuleModeller modeller;
    private FactPattern pattern;
    private final CompositeFieldConstraint constraint;

    public AddCompositeConstraintOptionDialog(Shell shell, RuleModeller ruleModeller, CompositeFieldConstraint compositeFieldConstraint, FactPattern factPattern) {
        super(shell, "Add fields to this constriant", "Pick the value from combo.");
        this.modeller = ruleModeller;
        this.constraint = compositeFieldConstraint;
        this.pattern = factPattern;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.createFieldRestrictionCombo(composite2, gridData);
        this.createMultiFieldCombo(composite2, gridData);
        return composite2;
    }

    private void createFieldRestrictionCombo(Composite composite, GridData gridData) {
        this.createLabel(composite, "Add a restriction on a field");
        final Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)gridData);
        combo.add("...");
        String[] stringArray = this.modeller.getSuggestionCompletionEngine().getFieldCompletions(this.pattern.factType);
        int n = 0;
        while (n < stringArray.length) {
            combo.add(stringArray[n]);
            ++n;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddCompositeConstraintOptionDialog.this.constraint.addConstraint((FieldConstraint)new SingleFieldConstraint(combo.getText()));
                AddCompositeConstraintOptionDialog.this.modeller.setDirty(true);
                AddCompositeConstraintOptionDialog.this.modeller.reloadLhs();
                AddCompositeConstraintOptionDialog.this.close();
            }
        });
    }

    private void createMultiFieldCombo(Composite composite, GridData gridData) {
        this.createLabel(composite, "Multiple field constraint");
        final Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)gridData);
        combo.add("...");
        combo.add("All of (And)");
        combo.add("Any of (Or)");
        combo.setData("All of (And)", (Object)"&&");
        combo.setData("Any of (Or)", (Object)"||");
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                CompositeFieldConstraint compositeFieldConstraint = new CompositeFieldConstraint();
                compositeFieldConstraint.compositeJunctionType = combo.getText();
                AddCompositeConstraintOptionDialog.this.constraint.addConstraint((FieldConstraint)compositeFieldConstraint);
                AddCompositeConstraintOptionDialog.this.modeller.reloadLhs();
                AddCompositeConstraintOptionDialog.this.modeller.setDirty(true);
                AddCompositeConstraintOptionDialog.this.close();
            }
        });
    }
}

