/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.Arrays;
import java.util.List;
import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class AddNewActionDialog
extends RuleDialog {
    private RuleModeller modeller;

    public AddNewActionDialog(Shell shell, RuleModeller ruleModeller) {
        super(shell, "Add a new action", "Pick the values from combos and confirm the selection.");
        this.modeller = ruleModeller;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        String string = "Choose...";
        this.createValuesOfFieldPart(composite2, string);
        this.createModifyFieldPart(composite2, string);
        this.createRetractFieldPart(composite2, string);
        String[] stringArray = this.getCompletion().getFactTypes();
        this.createFactAssertionPart(composite2, string, stringArray);
        this.createFactLogicalAssertionPart(composite2, string, stringArray);
        this.createDrlSentences(composite2);
        return composite2;
    }

    private void createDrlSentences(Composite composite) {
        this.createLabel(composite, "Free form action");
        Button button = new Button(composite, 0);
        button.setText("Add free form drl");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new FreeFormLine());
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createRetractFieldPart(Composite composite, String string) {
        this.createLabel(composite, "Retract the fact");
        final Combo combo = new Combo(composite, 8);
        combo.add(string);
        List list = this.modeller.getModel().getBoundFacts();
        int n = 0;
        while (n < list.size()) {
            combo.add((String)list.get(n));
            ++n;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionRetractFact(combo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createModifyFieldPart(Composite composite, String string) {
        this.createLabel(composite, "Modify a field on a fact");
        final Combo combo = new Combo(composite, 8);
        combo.add(string);
        List list = this.modeller.getModel().getBoundFacts();
        int n = 0;
        while (n < list.size()) {
            combo.add((String)list.get(n));
            ++n;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionUpdateField(combo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createDslSentences(Composite composite, String string) {
        if (this.getCompletion().getDSLActions().length > 0) {
            this.createLabel(composite, "Actions");
            final Combo combo = new Combo(composite, 8);
            combo.add(string);
            int n = 0;
            while (n < this.getCompletion().getDSLActions().length) {
                DSLSentence dSLSentence = this.getCompletion().getDSLActions()[n];
                combo.add(dSLSentence.toString());
                ++n;
            }
            combo.select(0);
            combo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (combo.getSelectionIndex() == 0) {
                        return;
                    }
                    DSLSentence dSLSentence = AddNewActionDialog.this.getCompletion().getDSLActions()[combo.getSelectionIndex() - 1];
                    AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)dSLSentence.copy());
                    AddNewActionDialog.this.modeller.setDirty(true);
                    AddNewActionDialog.this.modeller.reloadRhs();
                    AddNewActionDialog.this.close();
                }
            });
        }
    }

    private void createFactLogicalAssertionPart(Composite composite, String string, String[] stringArray) {
        this.createLabel(composite, "Logically insert a new fact");
        final Combo combo = this.createFactsCombo(composite, string, stringArray);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionInsertLogicalFact(combo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private void createFactAssertionPart(Composite composite, String string, String[] stringArray) {
        this.createLabel(composite, "Assert a new fact");
        final Combo combo = this.createFactsCombo(composite, string, stringArray);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionInsertFact(combo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    private Combo createFactsCombo(Composite composite, String string, String[] stringArray) {
        Combo combo = new Combo(composite, 8);
        combo.add(string);
        int n = 0;
        while (n < stringArray.length) {
            combo.add(stringArray[n]);
            ++n;
        }
        combo.select(0);
        return combo;
    }

    private void createValuesOfFieldPart(Composite composite, String string) {
        this.createLabel(composite, "Set the values of a field on");
        final Combo combo = new Combo(composite, 8);
        combo.add(string);
        List list = this.modeller.getModel().getBoundFacts();
        String[] stringArray = this.modeller.getSuggestionCompletionEngine().getGlobalVariables();
        list.addAll(Arrays.asList(stringArray));
        int n = 0;
        while (n < list.size()) {
            combo.add((String)list.get(n));
            ++n;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewActionDialog.this.modeller.getModel().addRhsItem((IAction)new ActionSetField(combo.getText()));
                AddNewActionDialog.this.modeller.setDirty(true);
                AddNewActionDialog.this.modeller.reloadRhs();
                AddNewActionDialog.this.close();
            }
        });
    }

    public SuggestionCompletionEngine getCompletion() {
        return this.modeller.getSuggestionCompletionEngine();
    }
}

