/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class AddNewConditionDialog
extends RuleDialog {
    private IPattern pattern;
    private RuleModeller modeller;

    public AddNewConditionDialog(Shell shell, RuleModeller ruleModeller) {
        super(shell, "Add new condition to the rule", "Pick the values from combos and confirm the selection.");
        this.modeller = ruleModeller;
    }

    protected Control createDialogArea(Composite composite) {
        Control control = super.createDialogArea(composite);
        Composite composite2 = (Composite)control;
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        this.addFacts(composite2);
        this.addConditionType(composite2);
        this.addDSLSentences(composite2);
        this.addFreeFormLine(composite2);
        return composite2;
    }

    private void addFreeFormLine(Composite composite) {
        this.createLabel(composite, "Free form action");
        Button button = new Button(composite, 0);
        button.setText("Add free form drl");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)new FreeFormLine());
                AddNewConditionDialog.this.modeller.setDirty(true);
                AddNewConditionDialog.this.modeller.reloadLhs();
                AddNewConditionDialog.this.close();
            }
        });
    }

    private void addFacts(Composite composite) {
        this.createLabel(composite, "Fact");
        String[] stringArray = this.getCompletion().getFactTypes();
        final Combo combo = new Combo(composite, 8);
        combo.add("Choose fact type...");
        int n = 0;
        while (n < stringArray.length) {
            combo.add(stringArray[n]);
            ++n;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)new FactPattern(combo.getText()));
                AddNewConditionDialog.this.modeller.reloadLhs();
                AddNewConditionDialog.this.modeller.setDirty(true);
                AddNewConditionDialog.this.close();
            }
        });
    }

    private void addConditionType(Composite composite) {
        this.createLabel(composite, "Condition type");
        final Combo combo = new Combo(composite, 8);
        String[] stringArray = this.getCompletion().getConditionalElements();
        combo.add("Choose condition type...");
        int n = 0;
        while (n < stringArray.length) {
            combo.add(stringArray[n]);
            ++n;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)new CompositeFactPattern(combo.getText()));
                AddNewConditionDialog.this.modeller.reloadLhs();
                AddNewConditionDialog.this.modeller.setDirty(true);
                AddNewConditionDialog.this.close();
            }
        });
    }

    private void addDSLSentences(Composite composite) {
        if (this.getCompletion().getDSLConditions().length > 0) {
            this.createLabel(composite, "Condition sentences");
            final Combo combo = new Combo(composite, 8);
            combo.add("Choose...");
            int n = 0;
            while (n < this.getCompletion().getDSLConditions().length) {
                DSLSentence dSLSentence = this.getCompletion().getDSLConditions()[n];
                combo.add(dSLSentence.toString());
                ++n;
            }
            combo.select(0);
            combo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (combo.getSelectionIndex() == 0) {
                        return;
                    }
                    DSLSentence dSLSentence = AddNewConditionDialog.this.getCompletion().getDSLConditions()[combo.getSelectionIndex() - 1];
                    AddNewConditionDialog.this.modeller.getModel().addLhsItem((IPattern)dSLSentence.copy());
                    AddNewConditionDialog.this.modeller.reloadLhs();
                    AddNewConditionDialog.this.modeller.setDirty(true);
                    AddNewConditionDialog.this.close();
                }
            });
        }
    }

    public IPattern getPattern() {
        return this.pattern;
    }

    private SuggestionCompletionEngine getCompletion() {
        return this.modeller.getSuggestionCompletionEngine();
    }
}

