/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AssignFieldVariableDialog
extends RuleDialog {
    private final FormToolkit toolkit;
    private RuleModeller modeller;
    private SingleFieldConstraint con;
    private final FactPattern pattern;

    public AssignFieldVariableDialog(Shell shell, FormToolkit formToolkit, RuleModeller ruleModeller, SingleFieldConstraint singleFieldConstraint, FactPattern factPattern) {
        super(shell, "Bind the field called [" + singleFieldConstraint.fieldName + "] to a variable.", "Type the variable name and hit the button.");
        this.toolkit = formToolkit;
        this.modeller = ruleModeller;
        this.con = singleFieldConstraint;
        this.pattern = factPattern;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createVariableBindingRow(composite2);
        this.createSubfieldConstraintRow(composite2);
        this.toolkit.paintBordersFor(composite2);
        return composite2;
    }

    private void createSubfieldConstraintRow(Composite composite) {
        SuggestionCompletionEngine suggestionCompletionEngine = this.modeller.getSuggestionCompletionEngine();
        String[] stringArray = suggestionCompletionEngine.getFieldCompletions(this.con.fieldType);
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        this.createLabel(composite, "Add a restriction on a subfield");
        final Combo combo = new Combo(composite, 12);
        combo.add("...");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            combo.add(string);
            combo.setData(string, (Object)suggestionCompletionEngine.getFieldType(String.valueOf(this.con.fieldType) + "." + string));
            ++n;
        }
        combo.select(0);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = combo.getText();
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                AssignFieldVariableDialog.this.pattern.addConstraint((FieldConstraint)new SingleFieldConstraint(string, (String)combo.getData(string), (FieldConstraint)AssignFieldVariableDialog.this.con));
                AssignFieldVariableDialog.this.modeller.setDirty(true);
                AssignFieldVariableDialog.this.modeller.reloadLhs();
                AssignFieldVariableDialog.this.close();
            }
        });
    }

    private void createVariableBindingRow(Composite composite) {
        this.createLabel(composite, "Variable name");
        final Text text = this.toolkit.createText(composite, "");
        if (this.con.fieldBinding != null) {
            text.setText(this.con.fieldBinding);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        text.setLayoutData((Object)gridData);
        Button button = this.toolkit.createButton(composite, "Set", 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((AssignFieldVariableDialog)AssignFieldVariableDialog.this).con.fieldBinding = text.getText();
                AssignFieldVariableDialog.this.modeller.reloadLhs();
                AssignFieldVariableDialog.this.modeller.setDirty(true);
                AssignFieldVariableDialog.this.close();
            }
        });
    }
}

