/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.AddNewFactConstraintDialog;
import org.drools.eclipse.rulebuilder.ui.FactPatternWidget;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class CompositeFactPatternWidget
extends Widget {
    private final CompositeFactPattern pattern;

    public CompositeFactPatternWidget(FormToolkit formToolkit, Composite composite, RuleModeller ruleModeller, CompositeFactPattern compositeFactPattern, int n) {
        super(composite, formToolkit, ruleModeller, n);
        this.pattern = compositeFactPattern;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 2;
        composite.setLayout((Layout)gridLayout);
        this.create();
    }

    private void create() {
        Label label = this.toolkit.createLabel(this.parent, HumanReadable.getCEDisplayName(this.pattern.type));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setBackground(new Color((Device)this.parent.getShell().getDisplay(), 240, 240, 240));
        label.setLayoutData((Object)gridData);
        this.addDeleteAction();
        this.addMoreOptionsAction();
        Composite composite = this.toolkit.createComposite(this.parent);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalAlignment = 0x1000000;
        composite.setLayoutData((Object)gridData2);
        this.createFactRows(this.toolkit, composite);
    }

    protected void addDeleteAction() {
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/delete_obj.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this ENTIRE condition, and all the field constraints that belong to it.");
                messageBox.setText("Remove this entire condition?");
                if (messageBox.open() == 64) {
                    if (CompositeFactPatternWidget.this.getModeller().getModel().removeLhsItem(CompositeFactPatternWidget.this.index)) {
                        CompositeFactPatternWidget.this.getModeller().reloadLhs();
                        CompositeFactPatternWidget.this.getModeller().setDirty(true);
                    } else {
                        CompositeFactPatternWidget.this.showMessage("Can't remove that item as it is used in the action part of the rule.");
                    }
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Remove the entire composite condition.");
    }

    private void addMoreOptionsAction() {
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/new_item.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                AddNewFactConstraintDialog addNewFactConstraintDialog = new AddNewFactConstraintDialog(CompositeFactPatternWidget.this.parent.getShell(), CompositeFactPatternWidget.this.getModeller(), CompositeFactPatternWidget.this.pattern);
                addNewFactConstraintDialog.open();
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Add a fact to this constraint. If it is an 'or' type, it will need at least 2.");
    }

    private void createFactRows(FormToolkit formToolkit, Composite composite) {
        if (this.pattern.patterns != null) {
            FactPattern[] factPatternArray = this.pattern.patterns;
            int n = 0;
            while (n < factPatternArray.length) {
                new FactPatternWidget(formToolkit, composite, this.getModeller(), factPatternArray[n], this.pattern, n, false);
                formToolkit.createLabel(composite, "");
                formToolkit.createLabel(composite, "");
                ++n;
            }
        }
    }
}

