/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.core.util.DateUtils;
import org.drools.eclipse.rulebuilder.ui.ModelWidget;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class DSLSentenceWidget
extends Widget {
    private static final String ENUM_TAG = "ENUM";
    private static final String DATE_TAG = "DATE";
    private static final String BOOLEAN_TAG = "BOOLEAN";
    private static final String ITEM_ = "ITEM_";
    private final DSLSentence sentence;
    protected SuggestionCompletionEngine completions;
    private List<ModelWidget> widgets = new ArrayList<ModelWidget>();

    public DSLSentenceWidget(FormToolkit formToolkit, Composite composite, DSLSentence dSLSentence, RuleModeller ruleModeller, int n) {
        super(composite, formToolkit, ruleModeller, n);
        this.sentence = dSLSentence;
        this.completions = ruleModeller.getSuggestionCompletionEngine();
        Composite composite2 = this.makeWidgets(this.sentence.sentence);
        this.addDeleteAction(composite2);
        formToolkit.paintBordersFor(composite);
    }

    protected abstract void updateModel();

    private void addDeleteAction(Composite composite) {
        ImageHyperlink imageHyperlink = this.addImage(composite, "icons/delete_item_small.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this DSL sentence?");
                messageBox.setText("Remove this DSL sentence?");
                if (messageBox.open() == 64) {
                    DSLSentenceWidget.this.updateModel();
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Remove this condition.");
    }

    public Composite makeWidgets(String string) {
        ArrayList<ModelWidget> arrayList = new ArrayList<ModelWidget>();
        int n = string.indexOf("{");
        boolean bl = string.indexOf("{") == 0;
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
        } else if (!bl) {
            string2 = string;
        }
        this.parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = this.toolkit.createComposite(this.parent);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginBottom = 0;
        rowLayout.marginHeight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.pack = true;
        rowLayout.spacing = 0;
        rowLayout.center = true;
        composite.setLayout((Layout)rowLayout);
        arrayList.add(new LabelWidget(composite, string2));
        while (n > 0 || bl) {
            bl = false;
            int n2 = string.indexOf("}", n);
            String string3 = string.substring(n + 1, n2);
            arrayList.add(this.addVariable(composite, string3));
            n = string.indexOf("{", n2);
            String string4 = n > 0 ? string.substring(n2 + 1, n) : string.substring(n2 + 1, string.length());
            if (string4.indexOf("\\n") > -1) {
                String[] stringArray = string4.split("\\\\n");
                int n3 = 0;
                while (n3 < stringArray.length) {
                    composite = this.toolkit.createComposite(this.parent);
                    composite.setLayout((Layout)rowLayout);
                    arrayList.add(new NewLine(composite));
                    arrayList.add(new LabelWidget(composite, stringArray[n3]));
                    ++n3;
                }
                continue;
            }
            arrayList.add(new LabelWidget(composite, string4));
        }
        for (ModelWidget modelWidget : arrayList) {
            this.widgets.add(modelWidget);
        }
        this.updateSentence();
        return composite;
    }

    public ModelWidget addVariable(Composite composite, String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            String string2 = string.substring(n + 1, string.length());
            int n2 = string2.indexOf(":");
            if (n2 > 0) {
                String string3 = string.substring(n + 1, n + n2 + 1);
                if (string3.equalsIgnoreCase(ENUM_TAG)) {
                    return this.addEnumDropdown(composite, string);
                }
                if (string3.equalsIgnoreCase(DATE_TAG)) {
                    return this.addDateSelector(composite, string);
                }
                if (string3.equalsIgnoreCase(BOOLEAN_TAG)) {
                    return this.addCheckbox(composite, string);
                }
            } else {
                String string4 = string.substring(n + 1, string.length());
                return this.addBox(composite, string, string4);
            }
        }
        return this.addBox(composite, string, "");
    }

    public ModelWidget addBox(Composite composite, String string, String string2) {
        int n = string.indexOf(":");
        if (n > 0) {
            string = string.substring(0, n);
        }
        FieldEditor fieldEditor = new FieldEditor(composite);
        fieldEditor.setVisibleLength(string.length() + 1);
        fieldEditor.setText(string);
        fieldEditor.setRestriction(string2);
        return fieldEditor;
    }

    public ModelWidget addCheckbox(Composite composite, String string) {
        return new DSLCheckBox(composite, string);
    }

    public ModelWidget addDateSelector(Composite composite, String string) {
        return new DSLDateSelector(composite, string);
    }

    private ModelWidget addEnumDropdown(Composite composite, String string) {
        return new DSLDropDown(composite, string);
    }

    protected void updateSentence() {
        String string = "";
        for (ModelWidget modelWidget : this.widgets) {
            String string2;
            String string3;
            ModelWidget modelWidget2;
            if (modelWidget instanceof LabelWidget) {
                string = String.valueOf(string) + ((LabelWidget)modelWidget).getText();
                continue;
            }
            if (modelWidget instanceof FieldEditor) {
                modelWidget2 = (FieldEditor)modelWidget;
                string3 = ((FieldEditor)modelWidget2).getText();
                string2 = ((FieldEditor)modelWidget2).getRestriction();
                if (!string2.equals("")) {
                    string3 = String.valueOf(string3) + ":" + string2;
                }
                string = String.valueOf(string) + " {" + string3 + "} ";
                continue;
            }
            if (modelWidget instanceof DSLDropDown) {
                modelWidget2 = (DSLDropDown)modelWidget;
                string3 = (Combo)((DSLDropDown)modelWidget2).getControl();
                string2 = ((DSLDropDown)modelWidget2).getType();
                String string4 = ((DSLDropDown)modelWidget2).getFactAndField();
                String string5 = ITEM_ + (string3.getSelectionIndex() + 1);
                Object object = string3.getData(string5);
                string = String.valueOf(string) + "{" + object + ":" + string2 + ":" + string4 + "} ";
                continue;
            }
            if (modelWidget instanceof DSLCheckBox) {
                modelWidget2 = (DSLCheckBox)modelWidget;
                string3 = ((DSLCheckBox)modelWidget2).getCheckedValue();
                string = String.valueOf(string) + "{" + string3 + ":" + ((DSLCheckBox)modelWidget2).getType() + ":" + string3 + "} ";
                continue;
            }
            if (modelWidget instanceof DSLDateSelector) {
                modelWidget2 = (DSLDateSelector)modelWidget;
                string3 = ((DSLDateSelector)modelWidget2).getDateString();
                string2 = ((DSLDateSelector)modelWidget2).getJavascriptFormat();
                string = String.valueOf(string) + "{" + string3 + ":" + ((DSLDateSelector)modelWidget2).getType() + ":" + string2 + "} ";
                continue;
            }
            if (!(modelWidget instanceof NewLine)) continue;
            string = String.valueOf(string) + "\\n";
        }
        this.sentence.sentence = string.trim();
    }

    class DSLCheckBox
    implements ModelWidget {
        Combo resultWidget = null;
        private String varName = "";
        private Composite control;

        public DSLCheckBox(Composite composite, String string) {
            this.control = DSLSentenceWidget.this.toolkit.createComposite(composite);
            this.control.setLayout((Layout)new RowLayout());
            int n = string.indexOf(":");
            int n2 = string.lastIndexOf(":");
            this.varName = string.substring(0, n);
            String string2 = string.substring(n2 + 1, string.length());
            this.resultWidget = new Combo(this.control, 8);
            this.resultWidget.add("true");
            this.resultWidget.add("false");
            if (string2.equalsIgnoreCase("true")) {
                this.resultWidget.select(0);
            } else {
                this.resultWidget.select(1);
            }
            this.resultWidget.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    DSLSentenceWidget.this.updateSentence();
                    ((DSLCheckBox)DSLCheckBox.this).DSLSentenceWidget.this.modeller.setDirty(true);
                }
            });
            this.resultWidget.setVisible(true);
            this.control.layout();
        }

        public Control getControl() {
            return this.control;
        }

        public Combo getListBox() {
            return this.resultWidget;
        }

        public void setListBox(Combo combo) {
            this.resultWidget = combo;
        }

        public String getType() {
            return DSLSentenceWidget.BOOLEAN_TAG;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String string) {
            this.varName = string;
        }

        public String getCheckedValue() {
            return this.resultWidget.getSelectionIndex() == 0 ? "true" : "false";
        }
    }

    class DSLDateSelector
    implements ModelWidget {
        private String varName = "";
        private String javascriptFormat = "";
        private final String defaultJavascriptFormat = "d-M-y";
        private final String javaFormat = DateUtils.getDateFormatMask();
        private SimpleDateFormat formatter = null;
        private Composite control;
        private Text field;

        public DSLDateSelector(Composite composite, String string) {
            this.control = DSLSentenceWidget.this.toolkit.createComposite(composite);
            this.control.setLayout((Layout)new RowLayout());
            int n = string.indexOf(":");
            int n2 = string.lastIndexOf(":");
            this.varName = string.substring(0, n);
            this.javascriptFormat = string.substring(n2 + 1, string.length());
            if (this.javascriptFormat.equals("") || this.javascriptFormat.equals("default")) {
                this.javascriptFormat = "d-M-y";
            }
            this.formatter = new SimpleDateFormat(this.javaFormat);
            Date date = new Date();
            if (!this.varName.equals("")) {
                try {
                    date = this.formatter.parse(this.varName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.field = DSLSentenceWidget.this.toolkit.createText(this.control, "");
            final Button button = new Button(this.control, 1028);
            if (date != null) {
                this.field.setText(this.formatter.format(date));
            }
            this.field.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    DSLSentenceWidget.this.updateSentence();
                    ((DSLDateSelector)DSLDateSelector.this).DSLSentenceWidget.this.modeller.setDirty(true);
                }
            });
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string;
                    final Shell shell = new Shell(button.getShell(), 67680);
                    shell.setText("Set date:");
                    shell.setLayout((Layout)new GridLayout(1, false));
                    final DateTime dateTime = new DateTime((Composite)shell, 1024);
                    Date date = new Date();
                    try {
                        string = DSLDateSelector.this.field.getText();
                        if (string != null && string.length() > 0) {
                            date = DSLDateSelector.this.formatter.parse(string);
                        }
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                    dateTime.setDate(date.getYear() + 1900, date.getMonth(), date.getDate());
                    string = button.toDisplay(0, 0);
                    int n = ((Point)string).x;
                    int n2 = ((Point)string).y + 20;
                    shell.setLocation(n, n2);
                    Button button2 = new Button((Composite)shell, 8);
                    button2.setText("OK");
                    button2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                    button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            DSLDateSelector.this.field.setText(DSLDateSelector.this.formatter.format(new Date(dateTime.getYear() - 1900, dateTime.getMonth(), dateTime.getDay())));
                            DSLSentenceWidget.this.updateSentence();
                            ((DSLDateSelector)(this).DSLDateSelector.this).DSLSentenceWidget.this.modeller.setDirty(true);
                            shell.close();
                        }
                    });
                    shell.setDefaultButton(button2);
                    shell.pack();
                    shell.open();
                }
            });
            this.control.layout();
        }

        public Control getControl() {
            return this.control;
        }

        public String getType() {
            return DSLSentenceWidget.DATE_TAG;
        }

        public String getJavascriptFormat() {
            return this.javascriptFormat;
        }

        public String getDateString() {
            String string;
            Date date = new Date();
            try {
                string = this.field.getText();
                if (string != null && string.length() > 0) {
                    date = this.formatter.parse(string);
                }
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return "";
            }
            string = "";
            string = date != null ? this.formatter.format(date) : this.varName;
            return string;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String string) {
            this.varName = string;
        }
    }

    class DSLDropDown
    implements ModelWidget {
        Combo resultWidget = null;
        private String varName = "";
        private String type = "";
        private String factAndField = "";

        public DSLDropDown(Composite composite, String string) {
            Composite composite2 = DSLSentenceWidget.this.toolkit.createComposite(composite);
            composite2.setLayout((Layout)new FillLayout());
            int n = string.indexOf(":");
            int n2 = string.lastIndexOf(":");
            this.varName = string.substring(0, n);
            this.type = string.substring(n + 1, n2);
            this.factAndField = string.substring(n2 + 1, string.length());
            int n3 = this.factAndField.indexOf(".");
            String string2 = this.factAndField.substring(0, n3);
            String string3 = this.factAndField.substring(n3 + 1, this.factAndField.length());
            String[] stringArray = DSLSentenceWidget.this.completions.getEnumValues(string2, string3);
            Combo combo = new Combo(composite2, 12);
            if (stringArray != null) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < stringArray.length) {
                    Object object;
                    String string4 = stringArray[n5];
                    String string5 = stringArray[n5];
                    if (stringArray[n5].indexOf(61) > -1) {
                        object = ConstraintValueEditorHelper.splitValue((String)stringArray[n5]);
                        string4 = object[0];
                        string5 = object[1];
                    }
                    if (this.varName.equals(string4)) {
                        n4 = n5;
                    }
                    combo.add(string5);
                    object = DSLSentenceWidget.ITEM_ + combo.getItemCount();
                    combo.setData((String)object, (Object)string4);
                    ++n5;
                }
                if (n4 >= 0) {
                    combo.select(n4);
                }
            }
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    DSLSentenceWidget.this.updateSentence();
                    DSLSentenceWidget.this.getModeller().setDirty(true);
                }
            });
            this.resultWidget = combo;
            composite2.layout();
        }

        public Control getControl() {
            return this.resultWidget;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getFactAndField() {
            return this.factAndField;
        }

        public void setFactAndField(String string) {
            this.factAndField = string;
        }
    }

    class FieldEditor
    implements ModelWidget {
        private Text control;
        private String oldValue = "";
        private String regex = "";

        public FieldEditor(Composite composite) {
            this.control = DSLSentenceWidget.this.toolkit.createText(composite, "");
            this.control.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    Text text = FieldEditor.this.control;
                    if (!FieldEditor.this.regex.equals("") && !text.getText().matches(FieldEditor.this.regex)) {
                        System.err.println("VALUE IS NOT VALID: " + text.getText());
                        FieldEditor.this.control.setText(FieldEditor.this.oldValue);
                    } else {
                        FieldEditor.this.oldValue = text.getText();
                        DSLSentenceWidget.this.updateSentence();
                        DSLSentenceWidget.this.getModeller().setDirty(true);
                    }
                }
            });
        }

        public void setText(String string) {
            this.control.setText(string);
        }

        public void setVisibleLength(int n) {
        }

        public Control getControl() {
            return this.control;
        }

        public String getText() {
            return this.control.getText();
        }

        public void setRestriction(String string) {
            this.regex = string;
        }

        public String getRestriction() {
            return this.regex;
        }

        public boolean isValid() {
            boolean bl = true;
            if (!this.regex.equals("")) {
                bl = this.control.getText().matches(this.regex);
            }
            return bl;
        }
    }

    class LabelWidget
    implements ModelWidget {
        private Label control;
        private String val;

        public LabelWidget(Composite composite, String string) {
            this.val = string;
            this.control = DSLSentenceWidget.this.toolkit.createLabel(composite, string);
        }

        public Control getControl() {
            return this.control;
        }

        public String getText() {
            return this.val;
        }
    }

    class NewLine
    implements ModelWidget {
        private Composite control;

        public NewLine(Composite composite) {
            this.control = DSLSentenceWidget.this.toolkit.createComposite(composite);
        }

        public Control getControl() {
            return this.control;
        }
    }
}

