/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class RuleAttributeWidget
extends Widget {
    public RuleAttributeWidget(FormToolkit formToolkit, Composite composite, RuleModeller ruleModeller) {
        super(composite, formToolkit, ruleModeller, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.create();
    }

    private void create() {
        RuleAttribute[] ruleAttributeArray = this.modeller.getModel().attributes;
        int n = 0;
        while (n < ruleAttributeArray.length) {
            RuleAttribute ruleAttribute = ruleAttributeArray[n];
            this.addAttribute(ruleAttribute);
            ++n;
        }
        this.toolkit.paintBordersFor(this.parent);
    }

    private void addAttribute(RuleAttribute ruleAttribute) {
        this.toolkit.createLabel(this.parent, ruleAttribute.attributeName);
        if (ruleAttribute.attributeName.equals("no-loop")) {
            this.toolkit.createLabel(this.parent, "");
        } else if (ruleAttribute.attributeName.equals("enabled") || ruleAttribute.attributeName.equals("auto-focus") || ruleAttribute.attributeName.equals("lock-on-active")) {
            this.createCheckbox(ruleAttribute);
        } else {
            this.createText(ruleAttribute);
        }
        this.addDeleteLink(ruleAttribute);
    }

    private void createText(final RuleAttribute ruleAttribute) {
        final Text text = this.toolkit.createText(this.parent, "");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.setText(ruleAttribute.value);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ruleAttribute.value = text.getText();
                RuleAttributeWidget.this.modeller.setDirty(true);
            }
        });
        if ((ruleAttribute.attributeName.equals("date-effective") || ruleAttribute.attributeName.equals("date-expires")) && (ruleAttribute.value == null || "".equals(ruleAttribute.value.trim()))) {
            text.setText("dd-MMM-yyyy");
        }
    }

    private void createCheckbox(final RuleAttribute ruleAttribute) {
        final Button button = this.toolkit.createButton(this.parent, "", 32);
        if (ruleAttribute.value == null) {
            button.setSelection(true);
            ruleAttribute.value = "true";
        } else {
            button.setSelection(ruleAttribute.value.equals("true"));
        }
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ruleAttribute.value = button.getSelection() ? "true" : "false";
                RuleAttributeWidget.this.modeller.setDirty(true);
            }
        });
    }

    private void addDeleteLink(final RuleAttribute ruleAttribute) {
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/delete_item_small.gif");
        imageHyperlink.setToolTipText("Remove this fieldconstraint");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this rule option?");
                messageBox.setText("Remove this rule option?");
                if (messageBox.open() == 64) {
                    RuleAttribute[] ruleAttributeArray = RuleAttributeWidget.this.modeller.getModel().attributes;
                    int n = 0;
                    while (n < ruleAttributeArray.length) {
                        if (ruleAttributeArray[n] == ruleAttribute) {
                            RuleAttributeWidget.this.modeller.getModel().removeAttribute(n);
                            RuleAttributeWidget.this.modeller.setDirty(true);
                            RuleAttributeWidget.this.modeller.reloadOptions();
                        }
                        ++n;
                    }
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
    }

    public static List getAttributeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("...");
        arrayList.add("salience");
        arrayList.add("enabled");
        arrayList.add("date-effective");
        arrayList.add("date-expires");
        arrayList.add("no-loop");
        arrayList.add("agenda-group");
        arrayList.add("activation-group");
        arrayList.add("duration");
        arrayList.add("auto-focus");
        arrayList.add("lock-on-active");
        arrayList.add("ruleflow-group");
        arrayList.add("dialect");
        return arrayList;
    }
}

