/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.editors.RuleEditor;
import org.drools.eclipse.rulebuilder.ui.ActionInsertFactWidget;
import org.drools.eclipse.rulebuilder.ui.ActionInsertFreeFormLineWidget;
import org.drools.eclipse.rulebuilder.ui.ActionRetractFactWidget;
import org.drools.eclipse.rulebuilder.ui.ActionSetFieldWidget;
import org.drools.eclipse.rulebuilder.ui.AddNewActionDialog;
import org.drools.eclipse.rulebuilder.ui.AddNewConditionDialog;
import org.drools.eclipse.rulebuilder.ui.CompositeFactPatternWidget;
import org.drools.eclipse.rulebuilder.ui.FactPatternWidget;
import org.drools.eclipse.rulebuilder.ui.LHSDSLSentenceWidget;
import org.drools.eclipse.rulebuilder.ui.RHSDSLSentenceWidget;
import org.drools.eclipse.rulebuilder.ui.RuleAttributeWidget;
import org.drools.eclipse.rulebuilder.ui.RuleAttributesDialog;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class RuleModeller {
    private Composite ifComposite;
    private Composite thenComposite;
    private Composite optionsComposite;
    private final ScrolledForm form;
    private final FormToolkit toolkit;
    private RuleModel model;
    private boolean dirty;
    private RuleEditor editor;

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.editor.dirtyPropertyChanged();
    }

    public RuleModeller(ScrolledForm scrolledForm, FormToolkit formToolkit, RuleModel ruleModel, RuleEditor ruleEditor) {
        this.form = scrolledForm;
        this.toolkit = formToolkit;
        this.model = ruleModel;
        this.editor = ruleEditor;
        this.setTitleAndFont(scrolledForm);
        ColumnLayout columnLayout = new ColumnLayout();
        columnLayout.minNumColumns = 1;
        columnLayout.maxNumColumns = 1;
        scrolledForm.getBody().setLayout((Layout)columnLayout);
        Shell shell = new Shell(Display.getCurrent());
        AddNewConditionDialog addNewConditionDialog = new AddNewConditionDialog(shell, this);
        AddNewActionDialog addNewActionDialog = new AddNewActionDialog(shell, this);
        RuleAttributesDialog ruleAttributesDialog = new RuleAttributesDialog(shell, this);
        Section section = this.createMainSection(scrolledForm, formToolkit, "WHEN", (Window)addNewConditionDialog);
        Section section2 = this.createMainSection(scrolledForm, formToolkit, "THEN", (Window)addNewActionDialog);
        Section section3 = this.createMainSection(scrolledForm, formToolkit, "(options)", (Window)ruleAttributesDialog);
        ColumnLayout columnLayout2 = new ColumnLayout();
        columnLayout2.minNumColumns = 1;
        columnLayout2.maxNumColumns = 1;
        ((Composite)section.getClient()).setLayout((Layout)columnLayout2);
        ((Composite)section2.getClient()).setLayout((Layout)columnLayout2);
        ((Composite)section3.getClient()).setLayout((Layout)columnLayout2);
        section.setLayout((Layout)columnLayout2);
        section2.setLayout((Layout)columnLayout2);
        section3.setLayout((Layout)columnLayout2);
        this.ifComposite = (Composite)section.getClient();
        this.thenComposite = (Composite)section2.getClient();
        this.optionsComposite = (Composite)section3.getClient();
    }

    private void setTitleAndFont(ScrolledForm scrolledForm) {
        scrolledForm.setText("Guided rule editor");
        Font font = scrolledForm.getDisplay().getSystemFont();
        FontData[] fontDataArray = font.getFontData();
        if (fontDataArray.length > 0) {
            FontData fontData = fontDataArray[0];
            fontData.setHeight(fontData.getHeight() + 2);
            fontData.setStyle(1);
            Font font2 = new Font(font.getDevice(), fontData);
            scrolledForm.setFont(font2);
        }
    }

    public SuggestionCompletionEngine getSuggestionCompletionEngine() {
        return this.editor.getCompletionEngine();
    }

    public RuleModel getModel() {
        return this.model;
    }

    public void setModel(RuleModel ruleModel) {
        this.model = ruleModel;
    }

    private void clearComposite(Composite composite) {
        if (composite != null) {
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Control control = controlArray[n];
                control.dispose();
                ++n;
            }
        }
    }

    private void reloadCommon() {
        this.toolkit.paintBordersFor(this.form.getBody());
        this.form.redraw();
        Dialog.applyDialogFont((Control)this.form.getBody());
        this.form.reflow(true);
    }

    public void reloadRhs() {
        this.clearComposite(this.thenComposite);
        this.redrawRhs();
        this.reloadCommon();
    }

    public void reloadLhs() {
        this.clearComposite(this.ifComposite);
        this.redrawLhs();
        this.reloadCommon();
    }

    public void reloadOptions() {
        this.clearComposite(this.optionsComposite);
        this.redrawOptions();
        this.reloadCommon();
    }

    public void reloadWidgets() {
        this.reloadLhs();
        this.reloadRhs();
        this.reloadOptions();
    }

    private void redrawOptions() {
        Composite composite = this.toolkit.createComposite(this.optionsComposite);
        new RuleAttributeWidget(this.toolkit, composite, this);
    }

    private void redrawRhs() {
        int n = 0;
        while (n < this.model.rhs.length) {
            IAction iAction = this.model.rhs[n];
            if (iAction instanceof ActionSetField) {
                this.addActionSetFieldWidget(iAction, n);
            } else if (iAction instanceof ActionInsertFact) {
                this.addActionInsertFactWidget(iAction, n);
            } else if (iAction instanceof ActionRetractFact) {
                this.addActionRetractFactWidget(iAction, n);
            } else if (iAction instanceof DSLSentence) {
                this.addRHSDSLSentenceWidget(n, (DSLSentence)iAction);
            } else if (iAction instanceof FreeFormLine) {
                this.addFreeFormLine((FreeFormLine)iAction, n, true);
            }
            ++n;
        }
    }

    private void addFreeFormLine(FreeFormLine freeFormLine, int n, boolean bl) {
        Composite composite = null;
        composite = bl ? this.toolkit.createComposite(this.thenComposite) : this.toolkit.createComposite(this.ifComposite);
        new ActionInsertFreeFormLineWidget(this.toolkit, composite, this, freeFormLine, n, bl);
    }

    private void addActionInsertFactWidget(IAction iAction, int n) {
        Composite composite = this.toolkit.createComposite(this.thenComposite);
        new ActionInsertFactWidget(this.toolkit, composite, this, (ActionInsertFact)iAction, n);
    }

    private void redrawLhs() {
        IPattern iPattern;
        int n = 0;
        while (n < this.model.lhs.length) {
            iPattern = this.model.lhs[n];
            if (iPattern instanceof FactPattern) {
                this.addFactPatternWidget(n, (FactPattern)iPattern);
            }
            if (iPattern instanceof CompositeFactPattern) {
                this.addCompositeFactPatternWidget(n, (CompositeFactPattern)iPattern);
            } else if (!(iPattern instanceof DSLSentence) && iPattern instanceof FreeFormLine) {
                this.addFreeFormLine((FreeFormLine)iPattern, n, false);
            }
            ++n;
        }
        n = 0;
        while (n < this.model.lhs.length) {
            iPattern = this.model.lhs[n];
            if (iPattern instanceof DSLSentence) {
                this.addLHSDSLSentenceWidget(n, (DSLSentence)iPattern);
            }
            ++n;
        }
    }

    private void addActionRetractFactWidget(IAction iAction, int n) {
        Composite composite = this.toolkit.createComposite(this.thenComposite);
        new ActionRetractFactWidget(this.toolkit, composite, this, (ActionRetractFact)iAction, n);
    }

    private void addActionSetFieldWidget(IAction iAction, int n) {
        Composite composite = this.toolkit.createComposite(this.thenComposite);
        new ActionSetFieldWidget(this.toolkit, composite, this, this.model, (ActionSetField)iAction, n);
    }

    private void addRHSDSLSentenceWidget(int n, DSLSentence dSLSentence) {
        Composite composite = this.toolkit.createComposite(this.thenComposite);
        new RHSDSLSentenceWidget(this.toolkit, composite, dSLSentence, this, n);
    }

    private void addLHSDSLSentenceWidget(int n, DSLSentence dSLSentence) {
        Composite composite = this.toolkit.createComposite(this.ifComposite);
        new LHSDSLSentenceWidget(this.toolkit, composite, dSLSentence, this, n);
    }

    private void addCompositeFactPatternWidget(int n, CompositeFactPattern compositeFactPattern) {
        Composite composite = this.toolkit.createComposite(this.ifComposite);
        new CompositeFactPatternWidget(this.toolkit, composite, this, compositeFactPattern, n);
    }

    private void addFactPatternWidget(int n, FactPattern factPattern) {
        Composite composite = this.toolkit.createComposite(this.ifComposite);
        new FactPatternWidget(this.toolkit, composite, this, factPattern, null, n, true);
    }

    private Section createMainSection(ScrolledForm scrolledForm, FormToolkit formToolkit, String string, Window window) {
        ColumnLayout columnLayout = new ColumnLayout();
        columnLayout.minNumColumns = 1;
        columnLayout.maxNumColumns = 1;
        Section section = formToolkit.createSection(scrolledForm.getBody(), 322);
        section.setActiveToggleColor(formToolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(formToolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        section.setText(string);
        this.createAddToolItem(section, window);
        Composite composite = formToolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        return section;
    }

    private void createAddToolItem(Section section, final Window window) {
        ToolBar toolBar = new ToolBar((Composite)section, 0x800100);
        ToolItem toolItem = new ToolItem(toolBar, 2);
        toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"));
        toolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                window.open();
            }
        });
        section.setTextClient((Control)toolBar);
    }

    public void refresh() {
        this.ifComposite.layout();
        this.ifComposite.redraw();
        this.thenComposite.layout();
        this.thenComposite.redraw();
        this.optionsComposite.layout();
        this.optionsComposite.redraw();
    }
}

